/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.com.google.common.collect.ImmutableSet;
import alluxio.shaded.client.com.google.common.hash.HashFunction;
import alluxio.shaded.client.com.google.common.hash.Hashing;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.wire.WorkerIdentity;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;

public class JumpHashProvider {
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32_fixed();
    private final int mMaxAttempts;
    private final long mWorkerInfoUpdateIntervalNs;
    private static final long UNSIGNED_MASK = Long.MAX_VALUE;
    private static final long JUMP = 0x80000000L;
    private static final long CONSTANT = Long.parseUnsignedLong("2862933555777941757");
    private final AtomicLong mLastUpdatedTimestamp = new AtomicLong(System.nanoTime());
    private final LongAdder mUpdateCount = new LongAdder();
    private final AtomicReference<Set<WorkerIdentity>> mLastWorkers = new AtomicReference(ImmutableSet.of());
    @Nullable
    private volatile HashMap<Integer, WorkerIdentity> mActiveNodesByConsistentHashing;
    private final Object mInitLock = new Object();

    public JumpHashProvider(int maxAttempts, long workerListTtlMs) {
        this.mMaxAttempts = maxAttempts;
        this.mWorkerInfoUpdateIntervalNs = workerListTtlMs * 1000000L;
    }

    public List<WorkerIdentity> getMultiple(String key, int count) {
        LinkedHashSet<WorkerIdentity> workers = new LinkedHashSet<WorkerIdentity>();
        int attempts = 0;
        while (workers.size() < count && attempts < this.mMaxAttempts) {
            WorkerIdentity selectedWorker = this.get(key, ++attempts);
            workers.add(selectedWorker);
        }
        return ImmutableList.copyOf(workers);
    }

    public void refresh(Set<WorkerIdentity> workers) {
        Set<WorkerIdentity> lastWorkerIds;
        Preconditions.checkArgument(!workers.isEmpty(), "cannot refresh hash provider with empty worker list");
        this.maybeInitialize(workers);
        if (this.shouldRebuildActiveNodesMapExclusively() && !workers.equals(lastWorkerIds = this.mLastWorkers.get())) {
            this.mActiveNodesByConsistentHashing = JumpHashProvider.build(workers);
            this.mLastWorkers.set(workers);
            this.mUpdateCount.increment();
        }
    }

    private boolean shouldRebuildActiveNodesMapExclusively() {
        long lastUpdateTs = this.mLastUpdatedTimestamp.get();
        long currentTs = System.nanoTime();
        if (currentTs - lastUpdateTs > this.mWorkerInfoUpdateIntervalNs) {
            return this.mLastUpdatedTimestamp.compareAndSet(lastUpdateTs, currentTs);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInitialize(Set<WorkerIdentity> workers) {
        if (this.mActiveNodesByConsistentHashing == null) {
            Object object = this.mInitLock;
            synchronized (object) {
                if (this.mActiveNodesByConsistentHashing == null) {
                    this.mActiveNodesByConsistentHashing = JumpHashProvider.build(workers);
                    this.mLastWorkers.set(workers);
                    this.mLastUpdatedTimestamp.set(System.nanoTime());
                }
            }
        }
    }

    WorkerIdentity get(String key, int index) {
        HashMap<Integer, WorkerIdentity> hashMap = this.mActiveNodesByConsistentHashing;
        Preconditions.checkState(hashMap != null, "Hash provider is not properly initialized");
        return JumpHashProvider.get(hashMap, key, index);
    }

    @VisibleForTesting
    static WorkerIdentity get(HashMap<Integer, WorkerIdentity> hashMap, String key, int index) {
        int hashKey = HASH_FUNCTION.hashString(String.format("%s%d", key, index), StandardCharsets.UTF_8).asInt();
        int workerId = JumpHashProvider.jumpConsistentHash(hashKey, hashMap.size());
        return hashMap.get(workerId);
    }

    private static int jumpConsistentHash(int key, int buckets) {
        long hashValue = -1L;
        long k = key;
        long j = 0L;
        while (j < (long)buckets) {
            hashValue = j;
            k = k * CONSTANT + 1L;
            j = (long)((double)(hashValue + 1L) * (2.147483648E9 / JumpHashProvider.toDouble((k >>> 33) + 1L)));
        }
        return (int)hashValue;
    }

    private static double toDouble(long n) {
        double d = n & Long.MAX_VALUE;
        if (n < 0L) {
            d += 9.223372036854776E18;
        }
        return d;
    }

    @VisibleForTesting
    Set<WorkerIdentity> getLastWorkers() {
        return this.mLastWorkers.get();
    }

    @VisibleForTesting
    HashMap<Integer, WorkerIdentity> getActiveNodesMap() {
        return this.mActiveNodesByConsistentHashing;
    }

    @VisibleForTesting
    long getUpdateCount() {
        return this.mUpdateCount.sum();
    }

    @VisibleForTesting
    static HashMap<Integer, WorkerIdentity> build(Set<WorkerIdentity> workers) {
        Preconditions.checkArgument(!workers.isEmpty(), "worker list is empty");
        HashMap<Integer, WorkerIdentity> activeNodesByJumpConsistentHashing = new HashMap<Integer, WorkerIdentity>();
        int workerIndex = 0;
        for (WorkerIdentity worker : workers) {
            activeNodesByJumpConsistentHashing.put(workerIndex, worker);
            ++workerIndex;
        }
        return activeNodesByJumpConsistentHashing;
    }
}

