/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.client.file.URIStatus;
import alluxio.grpc.FileInfo;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.ListStatusPartialPResponse;
import java.util.ArrayList;
import java.util.List;

public class ListStatusPartialResult {
    private final List<URIStatus> mListings;
    private final boolean mTruncated;
    private final long mFileCount;

    public static ListStatusPartialResult fromProto(ListStatusPartialPResponse response) {
        ArrayList<URIStatus> listings = new ArrayList<URIStatus>(response.getFileInfosCount());
        for (FileInfo info : response.getFileInfosList()) {
            listings.add(new URIStatus(GrpcUtils.fromProto(info)));
        }
        return new ListStatusPartialResult(listings, response.getIsTruncated(), response.getFileCount());
    }

    public ListStatusPartialResult(List<URIStatus> listings, boolean isTruncated, long fileCount) {
        this.mListings = listings;
        this.mTruncated = isTruncated;
        this.mFileCount = fileCount;
    }

    public List<URIStatus> getListings() {
        return this.mListings;
    }

    public boolean isTruncated() {
        return this.mTruncated;
    }

    public long getFileCount() {
        return this.mFileCount;
    }
}

