/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.resource.AlluxioResourceLeakDetector;
import alluxio.shaded.client.io.netty.util.ResourceLeakDetector;
import alluxio.shaded.client.io.netty.util.ResourceLeakDetectorFactory;

public class AlluxioResourceLeakDetectorFactory
extends ResourceLeakDetectorFactory {
    private static final ResourceLeakDetectorFactory INSTANCE = new AlluxioResourceLeakDetectorFactory();
    private final boolean mExitOnLeak = (Boolean)Configuration.get(PropertyKey.LEAK_DETECTOR_EXIT_ON_LEAK);

    public static ResourceLeakDetectorFactory instance() {
        return INSTANCE;
    }

    @Override
    public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource, int samplingInterval, long maxActive) {
        return this.newResourceLeakDetector(resource, samplingInterval);
    }

    @Override
    public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource, int samplingInterval) {
        return new AlluxioResourceLeakDetector(resource, samplingInterval, this.mExitOnLeak);
    }
}

