/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.CacheContext;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.CacheUsage;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.store.PageReadTargetBuffer;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoExceptionCacheManager
implements CacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(NoExceptionCacheManager.class);
    private final CacheManager mCacheManager;

    public NoExceptionCacheManager(CacheManager cacheManager) {
        this.mCacheManager = cacheManager;
    }

    @Override
    public boolean put(PageId pageId, byte[] page) {
        try {
            return this.mCacheManager.put(pageId, page);
        }
        catch (Exception e) {
            LOG.error("Failed to put page {}", (Object)pageId, (Object)e);
            Metrics.PUT_ERRORS.inc();
            return false;
        }
    }

    @Override
    public boolean put(PageId pageId, ByteBuffer page, CacheContext cacheContext) {
        try {
            return this.mCacheManager.put(pageId, page, cacheContext);
        }
        catch (Exception e) {
            LOG.error("Failed to put page {}, cacheContext {}", new Object[]{pageId, cacheContext, e});
            Metrics.PUT_ERRORS.inc();
            return false;
        }
    }

    @Override
    public int get(PageId pageId, int bytesToRead, byte[] buffer, int offsetInBuffer) {
        try {
            return this.mCacheManager.get(pageId, bytesToRead, buffer, offsetInBuffer);
        }
        catch (Exception e) {
            LOG.error("Failed to get page {}", (Object)pageId, (Object)e);
            Metrics.GET_ERRORS.inc();
            return -1;
        }
    }

    @Override
    public int get(PageId pageId, int pageOffset, int bytesToRead, byte[] buffer, int offsetInBuffer) {
        try {
            return this.mCacheManager.get(pageId, pageOffset, bytesToRead, buffer, offsetInBuffer);
        }
        catch (Exception e) {
            LOG.error("Failed to get page {}, offset {}", new Object[]{pageId, pageOffset, e});
            Metrics.GET_ERRORS.inc();
            return -1;
        }
    }

    @Override
    public int get(PageId pageId, int pageOffset, int bytesToRead, byte[] buffer, int offsetInBuffer, CacheContext cacheContext) {
        try {
            return this.mCacheManager.get(pageId, pageOffset, bytesToRead, buffer, offsetInBuffer, cacheContext);
        }
        catch (Exception e) {
            LOG.error("Failed to get page {}, offset {} cacheContext {}", new Object[]{pageId, pageOffset, cacheContext, e});
            Metrics.GET_ERRORS.inc();
            return -1;
        }
    }

    @Override
    public int get(PageId pageId, int pageOffset, int bytesToRead, PageReadTargetBuffer buffer, CacheContext cacheContext) {
        try {
            return this.mCacheManager.get(pageId, pageOffset, bytesToRead, buffer, cacheContext);
        }
        catch (Exception e) {
            LOG.error("Failed to get page {}, offset {} cacheContext {}", new Object[]{pageId, pageOffset, cacheContext, e});
            Metrics.GET_ERRORS.inc();
            return -1;
        }
    }

    @Override
    public boolean delete(PageId pageId) {
        try {
            return this.mCacheManager.delete(pageId);
        }
        catch (Exception e) {
            LOG.error("Failed to delete page {}", (Object)pageId, (Object)e);
            Metrics.DELETE_ERRORS.inc();
            return false;
        }
    }

    @Override
    public CacheManager.State state() {
        return this.mCacheManager.state();
    }

    @Override
    public boolean append(PageId pageId, int appendAt, byte[] page, CacheContext cacheContext) {
        return this.mCacheManager.append(pageId, appendAt, page, cacheContext);
    }

    @Override
    public void close() throws Exception {
        try {
            this.mCacheManager.close();
        }
        catch (Exception e) {
            LOG.error("Failed to close CacheManager", (Throwable)e);
        }
    }

    @Override
    public List<PageId> getCachedPageIdsByFileId(String fileId, long fileLength) {
        return this.mCacheManager.getCachedPageIdsByFileId(fileId, fileLength);
    }

    @Override
    public Optional<CacheUsage> getUsage() {
        return this.mCacheManager.getUsage();
    }

    private static final class Metrics {
        private static final Counter DELETE_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_DELETE_ERRORS.getName());
        private static final Counter GET_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_GET_ERRORS.getName());
        private static final Counter PUT_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_PUT_ERRORS.getName());

        private Metrics() {
        }
    }
}

