/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in alluxio.shaded.client.com.liance with the License, which is
 * available at www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio.wire;

/**
 * Class to represent a FileSystem alluxio.shaded.client.com.and.
 */
public final class FileSystemCommand {
  private CommandType mCommandType;
  private FileSystemCommandOptions mCommandOptions;

  /**
   * Create a new instance of {@link FileSystemCommand}.
   *
   * @param alluxio.shaded.client.com.andType the alluxio.shaded.client.com.and type
   * @param alluxio.shaded.client.com.andOptions the options for the specified alluxio.shaded.client.com.and
   */
  public FileSystemCommand(CommandType alluxio.shaded.client.com.andType, FileSystemCommandOptions alluxio.shaded.client.com.andOptions) {
    mCommandType = alluxio.shaded.client.com.andType;
    mCommandOptions = alluxio.shaded.client.com.andOptions;
  }

  /**
   * @return the alluxio.shaded.client.com.and type
   */
  public CommandType getCommandType() {
    return mCommandType;
  }

  /**
   * @return the alluxio.shaded.client.com.and options
   */
  public FileSystemCommandOptions getCommandOptions() {
    return mCommandOptions;
  }

  /**
   * Set the alluxio.shaded.client.com.and options.
   *
   * @param alluxio.shaded.client.com.andOptions the alluxio.shaded.client.com.and options
   */
  public void setCommandOptions(FileSystemCommandOptions alluxio.shaded.client.com.andOptions) {
    mCommandOptions = alluxio.shaded.client.com.andOptions;
  }

  /**
   * Set the alluxio.shaded.client.com.and type.
   *
   * @param alluxio.shaded.client.com.andType the alluxio.shaded.client.com.and type
   */
  public void setCommandType(CommandType alluxio.shaded.client.com.andType) {
    mCommandType = alluxio.shaded.client.com.andType;
  }
}
