/*
 * Copyright 2015 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.grpc.netty;

import alluxio.shaded.client.io.grpc.ChannelCredentials;
import alluxio.shaded.client.io.grpc.Internal;
import alluxio.shaded.client.io.grpc.ManagedChannelProvider;

/** Provider for {@link NettyChannelBuilder} instances. */
@Internal
public final class NettyChannelProvider extends ManagedChannelProvider {
  @Override
  public boolean isAvailable() {
    return true;
  }

  @Override
  public int priority() {
    return 5;
  }

  @Override
  public NettyChannelBuilder builderForAddress(String name, int port) {
    return NettyChannelBuilder.forAddress(name, port);
  }

  @Override
  public NettyChannelBuilder builderForTarget(String target) {
    return NettyChannelBuilder.forTarget(target);
  }

  @Override
  public NewChannelBuilderResult newChannelBuilder(String target, ChannelCredentials creds) {
    ProtocolNegotiators.FromChannelCredentialsResult result = ProtocolNegotiators.from(creds);
    if (result.error != null) {
      return NewChannelBuilderResult.error(result.error);
    }
    return NewChannelBuilderResult.channelBuilder(
        new NettyChannelBuilder(target, creds, result.callCredentials, result.negotiator));
  }
}
