/*
 * Copyright 2011-2020 Amazon.alluxio.shaded.client.com. Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in alluxio.shaded.client.com.liance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.alluxio.shaded.client.com.apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package alluxio.shaded.client.com.amazonaws.client;

import alluxio.shaded.client.com.amazonaws.ClientConfiguration;
import alluxio.shaded.client.com.amazonaws.annotation.SdkProtectedApi;
import alluxio.shaded.client.com.amazonaws.auth.AWSCredentialsProvider;
import alluxio.shaded.client.com.amazonaws.client.builder.AdvancedConfig;
import alluxio.shaded.client.com.amazonaws.monitoring.MonitoringListener;
import alluxio.shaded.client.com.amazonaws.handlers.RequestHandler2;
import alluxio.shaded.client.com.amazonaws.internal.auth.SignerProvider;
import alluxio.shaded.client.com.amazonaws.metrics.RequestMetricCollector;
import alluxio.shaded.client.com.amazonaws.monitoring.CsmConfigurationProvider;
import alluxio.shaded.client.com.amazonaws.retry.RetryPolicyAdapter;
import alluxio.shaded.client.com.amazonaws.retry.v2.RetryPolicy;

import java.net.URI;
import java.util.List;

/**
 * Provides access to all params needed in a synchronous AWS service client constructor. Abstract
 * to allow additions to the params while maintaining backwards alluxio.shaded.client.com.atibility.
 */
@SdkProtectedApi
public abstract class AwsSyncClientParams {

    public abstract AWSCredentialsProvider getCredentialsProvider();

    public abstract ClientConfiguration getClientConfiguration();

    public abstract RequestMetricCollector getRequestMetricCollector();

    public abstract List<RequestHandler2> getRequestHandlers();

    public abstract CsmConfigurationProvider getClientSideMonitoringConfigurationProvider();

    public abstract MonitoringListener getMonitoringListener();

    public AdvancedConfig getAdvancedConfig() {
        return AdvancedConfig.EMPTY;
    }

    public SignerProvider getSignerProvider() {
        // Not currently used by AWS clients. The builder uses setRegion to configure endpoint
        // and signer and does not support custom endpoints or signers.
        return null;
    }

    public URI getEndpoint() {
        // Not currently used by AWS clients. The builder uses setRegion to configure endpoint
        // and signer and does not support custom endpoints or signers.
        return null;
    }

    public RetryPolicy getRetryPolicy() {
        final ClientConfiguration config = getClientConfiguration();
        return new RetryPolicyAdapter(config.getRetryPolicy(), config);
    }
}
