/*
 * Decompiled with CFR 0.152.
 */
package alluxio.retry;

import alluxio.retry.RetryPolicy;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CountingRetry
implements RetryPolicy {
    private final int mMaxRetries;
    private int mAttemptCount = 0;

    public CountingRetry(int maxRetries) {
        Preconditions.checkArgument(maxRetries >= 0, "Max retries must be a non-negative number");
        this.mMaxRetries = maxRetries;
    }

    @Override
    public int getAttemptCount() {
        return this.mAttemptCount;
    }

    @Override
    public boolean attempt() {
        if (this.mAttemptCount <= this.mMaxRetries) {
            ++this.mAttemptCount;
            return true;
        }
        return false;
    }

    public void reset() {
        this.mAttemptCount = 0;
    }

    @Override
    public RetryPolicy copy() {
        return new CountingRetry(this.mMaxRetries);
    }
}

