/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.client.file.FileInStream;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.FSDataInputStream;

public class AlluxioHdfsInputStream
extends FileInStream {
    private final FSDataInputStream mInput;

    public AlluxioHdfsInputStream(FSDataInputStream input) {
        this.mInput = Preconditions.checkNotNull(input, "null");
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.mInput.read(bytes);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        return this.mInput.read(bytes, offset, length);
    }

    @Override
    public int read() throws IOException {
        return this.mInput.read();
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        int totalBytesRead;
        if (this.mInput.getWrappedStream() instanceof ByteBufferReadable) {
            return this.mInput.read(buf);
        }
        int off = buf.position();
        int len = buf.remaining();
        if (buf.hasArray()) {
            byte[] byteArray = buf.array();
            totalBytesRead = this.read(byteArray, buf.arrayOffset() + off, len);
            if (totalBytesRead > 0) {
                buf.position(off + totalBytesRead);
            }
        } else {
            byte[] byteArray = new byte[len];
            totalBytesRead = this.read(byteArray);
            if (totalBytesRead > 0) {
                buf.put(byteArray, 0, totalBytesRead);
            }
        }
        return totalBytesRead;
    }

    @Override
    public long skip(long length) throws IOException {
        return this.mInput.skip(length);
    }

    @Override
    public int available() throws IOException {
        return this.mInput.available();
    }

    @Override
    public void close() throws IOException {
        this.mInput.close();
    }

    @Override
    public synchronized void mark(int limit) {
        this.mInput.mark(limit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.mInput.reset();
    }

    @Override
    public boolean markSupported() {
        return this.mInput.markSupported();
    }

    @Override
    public void seek(long position) throws IOException {
        this.mInput.seek(position);
    }

    @Override
    public long getPos() throws IOException {
        return this.mInput.getPos();
    }

    @Override
    public long remaining() {
        throw new UnsupportedOperationException("Remaining is not supported");
    }

    @Override
    public int positionedRead(long position, byte[] buffer, int offset, int length) throws IOException {
        return this.mInput.read(position, buffer, offset, length);
    }

    @Override
    public void unbuffer() {
        this.mInput.unbuffer();
    }
}

