/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.ConfigurationValueOptions;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.conf.path.PathConfiguration;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.ConfigProperty;
import alluxio.grpc.GetConfigurationPOptions;
import alluxio.grpc.GetConfigurationPResponse;
import alluxio.grpc.GrpcChannel;
import alluxio.grpc.GrpcChannelBuilder;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.MetaMasterConfigurationServiceGrpc;
import alluxio.grpc.Scope;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.com.google.common.collect.ImmutableMap;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.util.ConfigurationUtils;
import alluxio.util.io.PathUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    private static final AtomicReference<InstancedConfiguration> SERVER_CONFIG_REFERENCE = new AtomicReference();

    public static AlluxioProperties copyProperties() {
        return SERVER_CONFIG_REFERENCE.get().copyProperties();
    }

    public static void merge(Map<?, ?> properties, Source source) {
        SERVER_CONFIG_REFERENCE.get().merge(properties, source);
    }

    public static void set(PropertyKey key, Object value) {
        Configuration.set(key, value, Source.RUNTIME);
    }

    public static void set(PropertyKey key, Object value, Source source) {
        if (key.getType() == PropertyKey.PropertyType.STRING) {
            value = String.valueOf(value);
        }
        SERVER_CONFIG_REFERENCE.get().set(key, value, source);
    }

    public static void unset(PropertyKey key) {
        SERVER_CONFIG_REFERENCE.get().unset(key);
    }

    public static Object get(PropertyKey key) {
        return SERVER_CONFIG_REFERENCE.get().get(key);
    }

    public static Object get(PropertyKey key, ConfigurationValueOptions options) {
        return SERVER_CONFIG_REFERENCE.get().get(key, options);
    }

    public static <T> T getOrDefault(PropertyKey key, T defaultValue) {
        return SERVER_CONFIG_REFERENCE.get().getOrDefault(key, defaultValue);
    }

    public static Object getOrDefault(PropertyKey key, String defaultValue, ConfigurationValueOptions options) {
        return SERVER_CONFIG_REFERENCE.get().getOrDefault(key, defaultValue, options);
    }

    public static boolean isSet(PropertyKey key) {
        return SERVER_CONFIG_REFERENCE.get().isSet(key);
    }

    public static boolean isSetByUser(PropertyKey key) {
        return SERVER_CONFIG_REFERENCE.get().isSetByUser(key);
    }

    public static Set<PropertyKey> keySet() {
        return SERVER_CONFIG_REFERENCE.get().keySet();
    }

    public static String getString(PropertyKey key) {
        return SERVER_CONFIG_REFERENCE.get().getString(key);
    }

    public static int getInt(PropertyKey key) {
        return SERVER_CONFIG_REFERENCE.get().getInt(key);
    }

    public static double getDouble(PropertyKey key) {
        return SERVER_CONFIG_REFERENCE.get().getDouble(key);
    }

    public static long getLong(PropertyKey key) {
        return SERVER_CONFIG_REFERENCE.get().getLong(key);
    }

    public static boolean getBoolean(PropertyKey key) {
        return SERVER_CONFIG_REFERENCE.get().getBoolean(key);
    }

    public static List<String> getList(PropertyKey key) {
        return SERVER_CONFIG_REFERENCE.get().getList(key);
    }

    public static <T extends Enum<T>> T getEnum(PropertyKey key, Class<T> enumType) {
        return SERVER_CONFIG_REFERENCE.get().getEnum(key, enumType);
    }

    public static long getBytes(PropertyKey key) {
        return SERVER_CONFIG_REFERENCE.get().getBytes(key);
    }

    public static long getMs(PropertyKey key) {
        return SERVER_CONFIG_REFERENCE.get().getMs(key);
    }

    public static Duration getDuration(PropertyKey key) {
        return SERVER_CONFIG_REFERENCE.get().getDuration(key);
    }

    public static <T> Class<T> getClass(PropertyKey key) {
        return SERVER_CONFIG_REFERENCE.get().getClass(key);
    }

    public static Map<String, Object> getNestedProperties(PropertyKey prefixKey) {
        return SERVER_CONFIG_REFERENCE.get().getNestedProperties(prefixKey);
    }

    public static Source getSource(PropertyKey key) {
        return SERVER_CONFIG_REFERENCE.get().getSource(key);
    }

    public static Map<String, Object> toMap() {
        return SERVER_CONFIG_REFERENCE.get().toMap();
    }

    public static Map<String, Object> toMap(ConfigurationValueOptions opts) {
        return SERVER_CONFIG_REFERENCE.get().toMap(opts);
    }

    public static AlluxioConfiguration global() {
        return SERVER_CONFIG_REFERENCE.get();
    }

    public static InstancedConfiguration modifiableGlobal() {
        return SERVER_CONFIG_REFERENCE.get();
    }

    public static InstancedConfiguration copyGlobal() {
        InstancedConfiguration configuration = SERVER_CONFIG_REFERENCE.get();
        return new InstancedConfiguration(configuration.copyProperties(), configuration.clusterDefaultsLoaded());
    }

    public static List<ConfigProperty> getConfiguration(Scope scope) {
        AlluxioConfiguration conf = Configuration.global();
        ConfigurationValueOptions useRawDisplayValue = ConfigurationValueOptions.defaults().useDisplayValue(true);
        return conf.keySet().stream().filter(key -> GrpcUtils.contains(key.getScope(), scope)).map(key -> {
            ConfigProperty.Builder configProp = ConfigProperty.newBuilder().setName(key.getName()).setSource(conf.getSource((PropertyKey)key).toString());
            if (conf.isSet((PropertyKey)key)) {
                configProp.setValue(String.valueOf(conf.get((PropertyKey)key, useRawDisplayValue)));
            }
            return configProp.build();
        }).collect(ImmutableList.toImmutableList());
    }

    public static void loadClusterDefaults(InetSocketAddress address, Scope scope) throws AlluxioStatusException {
        InstancedConfiguration conf = SERVER_CONFIG_REFERENCE.get();
        if (conf.getBoolean(PropertyKey.USER_CONF_CLUSTER_DEFAULT_ENABLED) && !conf.clusterDefaultsLoaded()) {
            GetConfigurationPResponse response;
            InstancedConfiguration newConf;
            while (!SERVER_CONFIG_REFERENCE.compareAndSet(conf = SERVER_CONFIG_REFERENCE.get(), newConf = Configuration.getClusterConf(response = Configuration.loadConfiguration(address, conf, false, true), conf, scope))) {
            }
        }
    }

    public static GetConfigurationPResponse loadConfiguration(InetSocketAddress address, AlluxioConfiguration conf, boolean ignoreClusterConf, boolean ignorePathConf) throws AlluxioStatusException {
        GrpcChannel channel = null;
        try {
            LOG.debug("Alluxio client (version {}) is trying to load configuration from meta master {}", (Object)"2.9.6", (Object)address);
            channel = GrpcChannelBuilder.newBuilder(GrpcServerAddress.create(address), conf).disableAuthentication().build();
            MetaMasterConfigurationServiceGrpc.MetaMasterConfigurationServiceBlockingStub client = MetaMasterConfigurationServiceGrpc.newBlockingStub(channel);
            GetConfigurationPResponse response = client.getConfiguration(GetConfigurationPOptions.newBuilder().setRawValue(true).setIgnoreClusterConf(ignoreClusterConf).setIgnorePathConf(ignorePathConf).build());
            LOG.debug("Alluxio client has loaded configuration from meta master {}", (Object)address);
            GetConfigurationPResponse getConfigurationPResponse = response;
            return getConfigurationPResponse;
        }
        catch (StatusRuntimeException e) {
            throw new UnavailableException(String.format("Failed to handshake with master %s to load cluster default configuration values: %s", address, e.getMessage()), e);
        }
        catch (UnauthenticatedException e) {
            throw new RuntimeException(String.format("Received authentication exception during boot-strap connect with host:%s", address), e);
        }
        finally {
            if (channel != null) {
                channel.shutdown();
            }
        }
    }

    public static InstancedConfiguration getClusterConf(GetConfigurationPResponse response, AlluxioConfiguration conf, Scope scope) {
        String clusterUfsVersion;
        String clientVersion = conf.getString(PropertyKey.VERSION);
        String clientUfsVersion = conf.getString(PropertyKey.UNDERFS_VERSION);
        LOG.debug("Alluxio {} (version {}) is trying to load cluster level configurations", (Object)scope, (Object)clientVersion);
        List<ConfigProperty> clusterConfig = response.getClusterConfigsList();
        Properties clusterProps = Configuration.filterAndLoadProperties(clusterConfig, scope, (key, value) -> String.format("Loading property: %s (%s) -> %s", key, key.getScope(), value));
        String clusterVersion = clusterProps.get(PropertyKey.VERSION).toString();
        if (!clientVersion.equals(clusterVersion)) {
            LOG.warn("Alluxio {} version ({}) does not match Alluxio cluster version ({})", new Object[]{scope, clientVersion, clusterVersion});
            clusterProps.remove(PropertyKey.VERSION);
        }
        if (clientUfsVersion.equals(clusterUfsVersion = clusterProps.get(PropertyKey.UNDERFS_VERSION).toString())) {
            clusterProps.remove(PropertyKey.UNDERFS_VERSION);
        }
        AlluxioProperties props = conf.copyProperties();
        props.merge(clusterProps, Source.CLUSTER_DEFAULT);
        InstancedConfiguration updatedConf = new InstancedConfiguration(props, true);
        updatedConf.validate();
        LOG.debug("Alluxio {} has loaded cluster level configurations", (Object)scope);
        return updatedConf;
    }

    public static PathConfiguration getPathConf(GetConfigurationPResponse response, AlluxioConfiguration clusterConf) {
        String clientVersion = clusterConf.getString(PropertyKey.VERSION);
        LOG.debug("Alluxio client (version {}) is trying to load path level configurations", (Object)clientVersion);
        HashMap<String, AlluxioConfiguration> pathConfs = new HashMap<String, AlluxioConfiguration>();
        response.getPathConfigsMap().forEach((path, conf) -> {
            Properties props = Configuration.filterAndLoadProperties(conf.getPropertiesList(), Scope.CLIENT, (key, value) -> String.format("Loading property: %s (%s) -> %s for path %s", key, key.getScope(), value, path));
            AlluxioProperties properties = new AlluxioProperties();
            properties.merge(props, Source.PATH_DEFAULT);
            pathConfs.put((String)path, new InstancedConfiguration(properties, true));
        });
        LOG.debug("Alluxio client has loaded path level configurations");
        return PathConfiguration.create(pathConfs);
    }

    private static Properties filterAndLoadProperties(List<ConfigProperty> properties, Scope scope, BiFunction<PropertyKey, String, String> logMessage) {
        Properties props = new Properties();
        for (ConfigProperty property : properties) {
            PropertyKey key;
            String name = property.getName();
            if (!PropertyKey.isValid(name) || !property.hasValue() || !GrpcUtils.contains((key = PropertyKey.fromString(name)).getScope(), scope)) continue;
            String value = property.getValue();
            props.put(key, value);
            LOG.debug(logMessage.apply(key, value));
        }
        return props;
    }

    public static String hash() {
        return SERVER_CONFIG_REFERENCE.get().hash();
    }

    private Configuration() {
    }

    public static void reloadProperties() {
        AlluxioProperties alluxioProperties = new AlluxioProperties();
        alluxioProperties.merge((Map)System.getProperties().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)), Source.SYSTEM_PROPERTY);
        InstancedConfiguration conf = new InstancedConfiguration(alluxioProperties);
        if (!conf.getBoolean(PropertyKey.TEST_MODE)) {
            for (String path : conf.getList(PropertyKey.SITE_CONF_DIR)) {
                String file = PathUtils.concatPath((Object)path, (Object)"alluxio-site.properties");
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Throwable throwable = null;
                    try {
                        Optional<Properties> properties = Configuration.loadProperties(fileInputStream);
                        if (!properties.isPresent()) continue;
                        alluxioProperties.merge(properties.get(), Source.siteProperty(file));
                        conf = new InstancedConfiguration(alluxioProperties);
                        conf.validate();
                        SERVER_CONFIG_REFERENCE.set(conf);
                        return;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileInputStream == null) continue;
                        if (throwable != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fileInputStream.close();
                    }
                }
                catch (FileNotFoundException fileInputStream) {
                }
                catch (IOException e) {
                    LOG.warn("Failed to close property input stream from {}: {}", (Object)file, (Object)e.toString());
                }
            }
            URL resource = ConfigurationUtils.class.getClassLoader().getResource("alluxio-site.properties");
            if (resource != null) {
                try (InputStream stream = resource.openStream();){
                    Optional<Properties> properties = Configuration.loadProperties(stream);
                    if (properties.isPresent()) {
                        alluxioProperties.merge(properties.get(), Source.siteProperty(resource.getPath()));
                        conf = new InstancedConfiguration(alluxioProperties);
                        conf.validate();
                        SERVER_CONFIG_REFERENCE.set(conf);
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to read properties from {}: {}", (Object)resource, (Object)e.toString());
                }
            }
        }
        conf.validate();
        SERVER_CONFIG_REFERENCE.set(conf);
    }

    private static Optional<Properties> loadProperties(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            LOG.warn("Unable to load properties: {}", (Object)e.toString());
            return Optional.empty();
        }
        return Optional.of(properties);
    }

    public static long getLastUpdateTime() {
        return SERVER_CONFIG_REFERENCE.get().getLastUpdateTime();
    }

    static {
        Configuration.reloadProperties();
    }
}

