/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.cuckoofilter;

import java.util.concurrent.atomic.AtomicLong;

public class SizeEncoder {
    protected final int mMaxSizeBits;
    protected final int mSizeGroupBits;
    protected final int mBitsPerBucket;
    protected final int mNumBuckets;
    protected final Bucket[] mBuckets;

    public SizeEncoder(int maxSizeBits, int numBucketsBits) {
        this.mMaxSizeBits = maxSizeBits;
        this.mSizeGroupBits = numBucketsBits;
        this.mBitsPerBucket = maxSizeBits - numBucketsBits;
        this.mNumBuckets = 1 << numBucketsBits;
        this.mBuckets = new Bucket[this.mNumBuckets];
        for (int i = 0; i < this.mNumBuckets; ++i) {
            this.mBuckets[i] = new Bucket();
        }
    }

    public void add(int size) {
        this.mBuckets[this.getSizeGroup(size)].add(size);
    }

    public int dec(int group) {
        int size = this.mBuckets[group].decrement();
        return size;
    }

    private int getSizeGroup(int size) {
        return Math.min(size >> this.mBitsPerBucket, this.mNumBuckets - 1);
    }

    public int encode(int size) {
        return this.getSizeGroup(size);
    }

    public String dumpInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.mNumBuckets; ++i) {
            stringBuilder.append(String.format("%d [%d, %d] <%d, %d>%n", i, (1 << this.mBitsPerBucket) * i, (1 << this.mBitsPerBucket) * (i + 1), this.mBuckets[i].getCount(), this.mBuckets[i].getSize()));
        }
        return stringBuilder.toString();
    }

    private class Bucket {
        private final AtomicLong mTotalBytes = new AtomicLong(0L);
        private final AtomicLong mCount = new AtomicLong(0L);

        private Bucket() {
        }

        public void add(int size) {
            this.mTotalBytes.addAndGet(size);
            this.mCount.incrementAndGet();
        }

        public int decrement() {
            int size = (int)this.getAverageSize();
            this.mTotalBytes.addAndGet(-size);
            this.mCount.decrementAndGet();
            return size;
        }

        public long getAverageSize() {
            return Math.round((double)this.mTotalBytes.get() / this.mCount.doubleValue());
        }

        public long getSize() {
            return this.mTotalBytes.get();
        }

        public long getCount() {
            return this.mCount.get();
        }
    }
}

