/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.compression;

import alluxio.shaded.client.org.apache.commons.io.FileUtils;
import alluxio.shaded.client.org.apache.commons.io.IOUtils;
import alluxio.util.compression.DirectoryMarshaller;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NoCompressionMarshaller
implements DirectoryMarshaller {
    private static final char DIR_CHAR = 'd';
    private static final char FILE_CHAR = 'f';

    @Override
    public long write(Path path, OutputStream outputStream) throws IOException, InterruptedException {
        long totalBytesCopied = 0L;
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);
             DataOutputStream dataOS = new DataOutputStream(outputStream);){
            for (Path subpath : stream.collect(Collectors.toList())) {
                byte[] relativePath = path.relativize(subpath).toString().getBytes();
                dataOS.write(relativePath.length);
                dataOS.write(relativePath);
                if (subpath.toFile().isDirectory()) {
                    dataOS.writeChar(100);
                    continue;
                }
                dataOS.writeChar(102);
                dataOS.writeLong(FileUtils.sizeOf(subpath.toFile()));
                BufferedInputStream fileIn = new BufferedInputStream(Files.newInputStream(subpath, new OpenOption[0]));
                Throwable throwable = null;
                try {
                    totalBytesCopied += IOUtils.copyLarge(fileIn, dataOS);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileIn == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)fileIn).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)fileIn).close();
                }
            }
        }
        return totalBytesCopied;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(Path path, InputStream inputStream) throws IOException {
        path.toFile().mkdirs();
        long totalBytesRead = 0L;
        try (DataInputStream dataIS = new DataInputStream(inputStream);){
            int pathSize;
            while ((pathSize = dataIS.read()) != -1) {
                BufferedOutputStream fileOut;
                block23: {
                    byte[] relativePath = new byte[pathSize];
                    dataIS.read(relativePath);
                    File filePath = new File(path.toFile(), new String(relativePath));
                    char c = dataIS.readChar();
                    if (c == 'd') {
                        filePath.mkdirs();
                        continue;
                    }
                    filePath.getParentFile().mkdirs();
                    long fileSize = dataIS.readLong();
                    fileOut = new BufferedOutputStream(Files.newOutputStream(filePath.toPath(), new OpenOption[0]));
                    Throwable throwable = null;
                    try {
                        totalBytesRead += IOUtils.copyLarge(dataIS, fileOut, 0L, fileSize);
                        if (fileOut == null) continue;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fileOut == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    ((OutputStream)fileOut).close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            ((OutputStream)fileOut).close();
                            throw throwable3;
                        }
                    }
                    try {
                        ((OutputStream)fileOut).close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                ((OutputStream)fileOut).close();
            }
            return totalBytesRead;
        }
    }
}

