/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl.lite;

import alluxio.shaded.client.software.amazon.ionIonTimestamp;
import alluxio.shaded.client.software.amazon.ionIonType;
import alluxio.shaded.client.software.amazon.ionIonWriter;
import alluxio.shaded.client.software.amazon.ionNullValueException;
import alluxio.shaded.client.software.amazon.ionTimestamp;
import alluxio.shaded.client.software.amazon.ionValueVisitor;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonValue;
import alluxio.shaded.client.software.amazon.ionimpl.lite.ContainerlessContext;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonContext;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonValueLite;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;

final class IonTimestampLite
extends IonValueLite
implements ionIonTimestamp {
    public static final Integer UTC_OFFSET = ionTimestamp.UTC_OFFSET;
    private static final int BIT_FLAG_YEAR = 1;
    private static final int BIT_FLAG_MONTH = 2;
    private static final int BIT_FLAG_DAY = 4;
    private static final int BIT_FLAG_MINUTE = 8;
    private static final int BIT_FLAG_SECOND = 16;
    private static final int BIT_FLAG_FRACTION = 32;
    private static final int HASH_SIGNATURE = ionIonType.TIMESTAMP.toString().hashCode();
    private ionTimestamp _timestamp_value;

    IonTimestampLite(ContainerlessContext context, boolean isNull) {
        super(context, isNull);
    }

    IonTimestampLite(IonTimestampLite existing, IonContext context) {
        super(existing, context);
        this._timestamp_value = existing._timestamp_value;
    }

    IonTimestampLite clone(IonContext context) {
        return new IonTimestampLite(this, context);
    }

    public IonTimestampLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int result = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            result ^= this.timestampValue().hashCode();
        }
        return this.hashTypeAnnotations(result, symbolTableProvider);
    }

    public ionIonType getType() {
        return ionIonType.TIMESTAMP;
    }

    public ionTimestamp timestampValue() {
        if (this.isNullValue()) {
            return null;
        }
        return this._timestamp_value;
    }

    public Date dateValue() {
        if (this._isNullValue()) {
            return null;
        }
        return this._timestamp_value.dateValue();
    }

    public Integer getLocalOffset() throws ionNullValueException {
        if (this._isNullValue()) {
            throw new ionNullValueException();
        }
        return this._timestamp_value.getLocalOffset();
    }

    private Integer getInternalLocalOffset() {
        if (this._isNullValue()) {
            return null;
        }
        return this._timestamp_value.getLocalOffset();
    }

    public void setValue(ionTimestamp timestamp) {
        this.checkForLock();
        this._timestamp_value = timestamp;
        this._isNullValue(timestamp == null);
    }

    public void setValue(BigDecimal millis, Integer localOffset) {
        this.setValue(ionTimestamp.forMillis(millis, localOffset));
    }

    public void setValue(long millis, Integer localOffset) {
        this.setValue(ionTimestamp.forMillis(millis, localOffset));
    }

    public void setTime(Date value) {
        if (value == null) {
            this.makeNull();
        } else {
            this.setMillis(value.getTime());
        }
    }

    public BigDecimal getDecimalMillis() {
        if (this._isNullValue()) {
            return null;
        }
        return this._timestamp_value.getDecimalMillis();
    }

    public void setDecimalMillis(BigDecimal millis) {
        Integer offset = this.getInternalLocalOffset();
        this.setValue(millis, offset);
    }

    public long getMillis() {
        if (this._isNullValue()) {
            throw new ionNullValueException();
        }
        return this._timestamp_value.getMillis();
    }

    public void setMillis(long millis) {
        Integer offset = this.getInternalLocalOffset();
        this.setValue(millis, offset);
    }

    public void setMillisUtc(long millis) {
        this.setValue(millis, UTC_OFFSET);
    }

    public void setCurrentTime() {
        long millis = System.currentTimeMillis();
        this.setMillis(millis);
    }

    public void setCurrentTimeUtc() {
        long millis = System.currentTimeMillis();
        this.setMillisUtc(millis);
    }

    public void setLocalOffset(int minutes) throws ionNullValueException {
        this.setLocalOffset(new Integer(minutes));
    }

    public void setLocalOffset(Integer minutes) throws ionNullValueException {
        this.validateThisNotNull();
        assert (this._timestamp_value != null);
        this.setValue(this._timestamp_value.getDecimalMillis(), minutes);
    }

    public void makeNull() {
        this.checkForLock();
        this._timestamp_value = null;
        this._isNullValue(true);
    }

    final void writeBodyTo(ionIonWriter writer, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        writer.writeTimestamp(this._timestamp_value);
    }

    public void accept(ionValueVisitor visitor) throws Exception {
        visitor.visit(this);
    }
}

