/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl.lite;

import alluxio.shaded.client.software.amazon.ionEmptySymbolException;
import alluxio.shaded.client.software.amazon.ionIonType;
import alluxio.shaded.client.software.amazon.ionIonWriter;
import alluxio.shaded.client.software.amazon.ionSymbolTable;
import alluxio.shaded.client.software.amazon.ionSymbolToken;
import alluxio.shaded.client.software.amazon.ionUnknownSymbolException;
import alluxio.shaded.client.software.amazon.ionValueVisitor;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonSymbol;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonValue;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateUtils;
import alluxio.shaded.client.software.amazon.ionimpl.lite.ContainerlessContext;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonContext;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonTextLite;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonValueLite;
import java.io.IOException;

final class IonSymbolLite
extends IonTextLite
implements PrivateIonSymbol {
    private static final int HASH_SIGNATURE = ionIonType.SYMBOL.toString().hashCode();
    private int _sid = -1;

    IonSymbolLite(ContainerlessContext context, boolean isNull) {
        super(context, isNull);
    }

    IonSymbolLite(IonSymbolLite existing, IonContext context) throws ionUnknownSymbolException {
        super(existing, context);
    }

    IonSymbolLite(ContainerlessContext context, ionSymbolToken sym) {
        super(context, sym == null);
        if (sym != null) {
            String text = sym.getText();
            int sid = sym.getSid();
            assert (text != null || sid > 0);
            if (text != null) {
                if (text.length() == 0) {
                    throw new ionEmptySymbolException();
                }
                super.setValue(text);
            } else {
                this._sid = sid;
            }
        }
    }

    IonSymbolLite clone(IonContext context) {
        return new IonSymbolLite(this, context);
    }

    public IonSymbolLite clone() throws ionUnknownSymbolException {
        if (!this.isNullValue() && this._sid != -1 && this._stringValue() == null) {
            throw new ionUnknownSymbolException(this._sid);
        }
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int sidHashSalt = 127;
        int textHashSalt = 31;
        int result = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            ionSymbolToken token = this.symbolValue(symbolTableProvider);
            String text = token.getText();
            int tokenHashCode = text == null ? token.getSid() * 127 : text.hashCode() * 31;
            tokenHashCode ^= tokenHashCode << 29 ^ tokenHashCode >> 3;
            result ^= tokenHashCode;
        }
        return this.hashTypeAnnotations(result, symbolTableProvider);
    }

    public ionIonType getType() {
        return ionIonType.SYMBOL;
    }

    private String _stringValue() {
        return this._stringValue(new IonValueLite.LazySymbolTableProvider(this));
    }

    private String _stringValue(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        String name = this._get_value();
        if (name == null) {
            assert (this._sid > 0);
            ionSymbolTable symbols = symbolTableProvider.getSymbolTable();
            name = symbols.findKnownSymbol(this._sid);
            if (name != null && !this._isLocked()) {
                this._set_value(name);
            }
        }
        return name;
    }

    public ionSymbolToken symbolValue() {
        return this.symbolValue(new IonValueLite.LazySymbolTableProvider(this));
    }

    private int resolveSymbolId() {
        ionSymbolToken tok;
        this.validateThisNotNull();
        if (this._sid != -1 || this.isReadOnly()) {
            return this._sid;
        }
        ionSymbolTable symtab = this.getSymbolTable();
        if (symtab == null) {
            symtab = this.getSystem().getSystemSymbolTable();
        }
        assert (symtab != null);
        String name = this._get_value();
        if (!symtab.isLocalTable()) {
            this._sid = symtab.findSymbol(name);
            if (this._sid > 0 || this.isReadOnly()) {
                return this._sid;
            }
        }
        if ((tok = symtab.find(name)) != null) {
            this._sid = tok.getSid();
            this._set_value(tok.getText());
        }
        return this._sid;
    }

    public ionSymbolToken symbolValue(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        if (this.isNullValue()) {
            return null;
        }
        int sid = this.resolveSymbolId();
        String text = this._stringValue(symbolTableProvider);
        return PrivateUtils.newSymbolToken(text, sid);
    }

    public void setValue(String value) {
        if ("".equals(value)) {
            throw new ionEmptySymbolException();
        }
        super.setValue(value);
        this._sid = -1;
    }

    protected boolean isIonVersionMarker() {
        return this._isIVM();
    }

    void clearSymbolIDValues() {
        super.clearSymbolIDValues();
        if (!this.isNullValue() && this._stringValue() != null) {
            this._sid = -1;
        }
    }

    protected void setIsIonVersionMarker(boolean isIVM) {
        assert ("$ion_1_0".equals(this._get_value()) == isIVM);
        this._isIVM(isIVM);
        this._isSystemValue(isIVM);
        this._sid = 2;
    }

    final void writeBodyTo(ionIonWriter writer, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        ionSymbolToken symbol = this.symbolValue(symbolTableProvider);
        writer.writeSymbolToken(symbol);
    }

    public String stringValue() throws ionUnknownSymbolException {
        return this.stringValue(new IonValueLite.LazySymbolTableProvider(this));
    }

    private String stringValue(PrivateIonValue.SymbolTableProvider symbolTableProvider) throws ionUnknownSymbolException {
        if (this.isNullValue()) {
            return null;
        }
        String name = this._stringValue(symbolTableProvider);
        if (name == null) {
            assert (this._sid > 0);
            throw new ionUnknownSymbolException(this._sid);
        }
        return name;
    }

    public void accept(ionValueVisitor visitor) throws Exception {
        visitor.visit(this);
    }
}

