/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.prometheus.metrics.model.snapshots;

import alluxio.shaded.client.io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import alluxio.shaded.client.io.prometheus.metrics.model.snapshots.MetricMetadata;
import alluxio.shaded.client.io.prometheus.metrics.model.snapshots.Unit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class MetricSnapshot {
    private final MetricMetadata metadata;
    protected final List<? extends DataPointSnapshot> dataPoints;

    protected MetricSnapshot(MetricMetadata metadata, DataPointSnapshot ... dataPoints) {
        this(metadata, Arrays.asList(dataPoints));
    }

    protected MetricSnapshot(MetricMetadata metadata, Collection<? extends DataPointSnapshot> dataPoints) {
        if (metadata == null) {
            throw new NullPointerException("metadata");
        }
        if (dataPoints == null) {
            throw new NullPointerException("dataPoints");
        }
        this.metadata = metadata;
        ArrayList<? extends DataPointSnapshot> dataCopy = new ArrayList<DataPointSnapshot>(dataPoints);
        dataCopy.sort(Comparator.comparing(DataPointSnapshot::getLabels));
        this.dataPoints = Collections.unmodifiableList(dataCopy);
        this.validateLabels();
    }

    public MetricMetadata getMetadata() {
        return this.metadata;
    }

    public abstract List<? extends DataPointSnapshot> getDataPoints();

    protected void validateLabels() {
        for (int i = 0; i < this.dataPoints.size() - 1; ++i) {
            if (!this.dataPoints.get(i).getLabels().equals(this.dataPoints.get(i + 1).getLabels())) continue;
            throw new IllegalArgumentException("Duplicate labels in metric data: " + this.dataPoints.get(i).getLabels());
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String name;
        private String help;
        private Unit unit;

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T help(String help) {
            this.help = help;
            return this.self();
        }

        public T unit(Unit unit) {
            this.unit = unit;
            return this.self();
        }

        protected MetricMetadata buildMetadata() {
            return new MetricMetadata(this.name, this.help, this.unit);
        }

        protected abstract T self();
    }
}

