/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.prometheus.metrics.config;

import alluxio.shaded.client.io.prometheus.metrics.config.PrometheusPropertiesException;
import alluxio.shaded.client.io.prometheus.metrics.config.Util;
import java.util.Map;

public class ExporterProperties {
    private static final String INCLUDE_CREATED_TIMESTAMPS = "includeCreatedTimestamps";
    private static final String EXEMPLARS_ON_ALL_METRIC_TYPES = "exemplarsOnAllMetricTypes";
    private final Boolean includeCreatedTimestamps;
    private final Boolean exemplarsOnAllMetricTypes;

    private ExporterProperties(Boolean includeCreatedTimestamps, Boolean exemplarsOnAllMetricTypes) {
        this.includeCreatedTimestamps = includeCreatedTimestamps;
        this.exemplarsOnAllMetricTypes = exemplarsOnAllMetricTypes;
    }

    public boolean getIncludeCreatedTimestamps() {
        return this.includeCreatedTimestamps != null && this.includeCreatedTimestamps != false;
    }

    public boolean getExemplarsOnAllMetricTypes() {
        return this.exemplarsOnAllMetricTypes != null && this.exemplarsOnAllMetricTypes != false;
    }

    static ExporterProperties load(String prefix, Map<Object, Object> properties) throws PrometheusPropertiesException {
        Boolean includeCreatedTimestamps = Util.loadBoolean(prefix + "." + INCLUDE_CREATED_TIMESTAMPS, properties);
        Boolean exemplarsOnAllMetricTypes = Util.loadBoolean(prefix + "." + EXEMPLARS_ON_ALL_METRIC_TYPES, properties);
        return new ExporterProperties(includeCreatedTimestamps, exemplarsOnAllMetricTypes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Boolean includeCreatedTimestamps;
        private Boolean exemplarsOnAllMetricTypes;

        private Builder() {
        }

        public Builder includeCreatedTimestamps(boolean includeCreatedTimestamps) {
            this.includeCreatedTimestamps = includeCreatedTimestamps;
            return this;
        }

        public Builder exemplarsOnAllMetricTypes(boolean exemplarsOnAllMetricTypes) {
            this.exemplarsOnAllMetricTypes = exemplarsOnAllMetricTypes;
            return this;
        }

        public ExporterProperties build() {
            return new ExporterProperties(this.includeCreatedTimestamps, this.exemplarsOnAllMetricTypes);
        }
    }
}

