/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol.databuffer;

import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.netty.channel.DefaultFileRegion;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class DataFileChannel
implements DataBuffer {
    private final File mFile;
    private final long mOffset;
    private final long mLength;

    public DataFileChannel(File file, long offset, long length) {
        this.mFile = Preconditions.checkNotNull(file, "file");
        this.mOffset = offset;
        this.mLength = length;
    }

    @Override
    public Object getNettyOutput() {
        return new DefaultFileRegion(this.mFile, this.mOffset, this.mLength);
    }

    @Override
    public long getLength() {
        return this.mLength;
    }

    @Override
    public ByteBuffer getReadOnlyByteBuffer() {
        throw new UnsupportedOperationException("DataFileChannel#getReadOnlyByteBuffer is not implemented.");
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        throw new UnsupportedOperationException("DataFileChannel#readBytes is not implemented.");
    }

    @Override
    public void readBytes(OutputStream outputStream, int length) throws IOException {
        throw new UnsupportedOperationException("DataFileChannel#readBytes is not implemented.");
    }

    @Override
    public void readBytes(ByteBuffer outputBuf) {
        throw new UnsupportedOperationException("DataFileChannel#readBytes is not implemented.");
    }

    @Override
    public int readableBytes() {
        int lengthInt = (int)this.mLength;
        Preconditions.checkArgument(this.mLength == (long)lengthInt, "size of file %s is %s, cannot be cast to int", (Object)this.mFile, this.mLength);
        return lengthInt;
    }

    @Override
    public void release() {
    }
}

