/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in alluxio.shaded.client.com.liance with the License, which is
 * available at www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio.master;

/***
 * The worker state maintained by master.
 */
public enum WorkerState {
  LIVE("ACTIVE"),
  LOST("LOST"),
  DECOMMISSIONED("Decommissioned"),
  DISABLED("Disabled");
  private final String mState;

  WorkerState(String s) {
    mState = s;
  }

  @Override
  public String toString() {
    return mState;
  }
}
