package alluxio.grpc;

import static alluxio.shaded.client.io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 **
 * This interface contains metrics master service endpoints for Alluxio clients.
 * </pre>
 */
@alluxio.shaded.client.javax.annotation.Generated(
    value = "by gRPC proto alluxio.shaded.client.com.iler (version 1.54.1)",
    alluxio.shaded.client.com.ents = "Source: grpc/metric_master.proto")
@alluxio.shaded.client.io.grpc.stub.annotations.GrpcGenerated
public final class MetricsMasterClientServiceGrpc {

  private MetricsMasterClientServiceGrpc() {}

  public static final String SERVICE_NAME = "alluxio.grpc.metric.MetricsMasterClientService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.ClearMetricsPRequest,
      alluxio.grpc.ClearMetricsPResponse> getClearMetricsMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ClearMetrics",
      requestType = alluxio.grpc.ClearMetricsPRequest.class,
      responseType = alluxio.grpc.ClearMetricsPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.ClearMetricsPRequest,
      alluxio.grpc.ClearMetricsPResponse> getClearMetricsMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.ClearMetricsPRequest, alluxio.grpc.ClearMetricsPResponse> getClearMetricsMethod;
    if ((getClearMetricsMethod = MetricsMasterClientServiceGrpc.getClearMetricsMethod) == null) {
      synchronized (MetricsMasterClientServiceGrpc.class) {
        if ((getClearMetricsMethod = MetricsMasterClientServiceGrpc.getClearMetricsMethod) == null) {
          MetricsMasterClientServiceGrpc.getClearMetricsMethod = getClearMetricsMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.ClearMetricsPRequest, alluxio.grpc.ClearMetricsPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ClearMetrics"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.ClearMetricsPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.ClearMetricsPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new MetricsMasterClientServiceMethodDescriptorSupplier("ClearMetrics"))
              .build();
        }
      }
    }
    return getClearMetricsMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.MetricsHeartbeatPRequest,
      alluxio.grpc.MetricsHeartbeatPResponse> getMetricsHeartbeatMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "MetricsHeartbeat",
      requestType = alluxio.grpc.MetricsHeartbeatPRequest.class,
      responseType = alluxio.grpc.MetricsHeartbeatPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.MetricsHeartbeatPRequest,
      alluxio.grpc.MetricsHeartbeatPResponse> getMetricsHeartbeatMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.MetricsHeartbeatPRequest, alluxio.grpc.MetricsHeartbeatPResponse> getMetricsHeartbeatMethod;
    if ((getMetricsHeartbeatMethod = MetricsMasterClientServiceGrpc.getMetricsHeartbeatMethod) == null) {
      synchronized (MetricsMasterClientServiceGrpc.class) {
        if ((getMetricsHeartbeatMethod = MetricsMasterClientServiceGrpc.getMetricsHeartbeatMethod) == null) {
          MetricsMasterClientServiceGrpc.getMetricsHeartbeatMethod = getMetricsHeartbeatMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.MetricsHeartbeatPRequest, alluxio.grpc.MetricsHeartbeatPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "MetricsHeartbeat"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.MetricsHeartbeatPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.MetricsHeartbeatPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new MetricsMasterClientServiceMethodDescriptorSupplier("MetricsHeartbeat"))
              .build();
        }
      }
    }
    return getMetricsHeartbeatMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetMetricsPOptions,
      alluxio.grpc.GetMetricsPResponse> getGetMetricsMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetMetrics",
      requestType = alluxio.grpc.GetMetricsPOptions.class,
      responseType = alluxio.grpc.GetMetricsPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetMetricsPOptions,
      alluxio.grpc.GetMetricsPResponse> getGetMetricsMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetMetricsPOptions, alluxio.grpc.GetMetricsPResponse> getGetMetricsMethod;
    if ((getGetMetricsMethod = MetricsMasterClientServiceGrpc.getGetMetricsMethod) == null) {
      synchronized (MetricsMasterClientServiceGrpc.class) {
        if ((getGetMetricsMethod = MetricsMasterClientServiceGrpc.getGetMetricsMethod) == null) {
          MetricsMasterClientServiceGrpc.getGetMetricsMethod = getGetMetricsMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetMetricsPOptions, alluxio.grpc.GetMetricsPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetMetrics"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetMetricsPOptions.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetMetricsPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new MetricsMasterClientServiceMethodDescriptorSupplier("GetMetrics"))
              .build();
        }
      }
    }
    return getGetMetricsMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static MetricsMasterClientServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<MetricsMasterClientServiceStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<MetricsMasterClientServiceStub>() {
        @java.lang.Override
        public MetricsMasterClientServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new MetricsMasterClientServiceStub(channel, callOptions);
        }
      };
    return MetricsMasterClientServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static MetricsMasterClientServiceBlockingStub newBlockingStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<MetricsMasterClientServiceBlockingStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<MetricsMasterClientServiceBlockingStub>() {
        @java.lang.Override
        public MetricsMasterClientServiceBlockingStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new MetricsMasterClientServiceBlockingStub(channel, callOptions);
        }
      };
    return MetricsMasterClientServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static MetricsMasterClientServiceFutureStub newFutureStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<MetricsMasterClientServiceFutureStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<MetricsMasterClientServiceFutureStub>() {
        @java.lang.Override
        public MetricsMasterClientServiceFutureStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new MetricsMasterClientServiceFutureStub(channel, callOptions);
        }
      };
    return MetricsMasterClientServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   **
   * This interface contains metrics master service endpoints for Alluxio clients.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     **
     * Clears the metrics in the cluster.
     * </pre>
     */
    default void clearMetrics(alluxio.grpc.ClearMetricsPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.ClearMetricsPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getClearMetricsMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Periodic metrics master client heartbeat.
     * </pre>
     */
    default void metricsHeartbeat(alluxio.grpc.MetricsHeartbeatPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.MetricsHeartbeatPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getMetricsHeartbeatMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Returns a map of metrics property names and their values from Alluxio metrics system.
     * </pre>
     */
    default void getMetrics(alluxio.grpc.GetMetricsPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetMetricsPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetMetricsMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service MetricsMasterClientService.
   * <pre>
   **
   * This interface contains metrics master service endpoints for Alluxio clients.
   * </pre>
   */
  public static abstract class MetricsMasterClientServiceImplBase
      implements alluxio.shaded.client.io.grpc.BindableService, AsyncService {

    @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
      return MetricsMasterClientServiceGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service MetricsMasterClientService.
   * <pre>
   **
   * This interface contains metrics master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class MetricsMasterClientServiceStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractAsyncStub<MetricsMasterClientServiceStub> {
    private MetricsMasterClientServiceStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MetricsMasterClientServiceStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new MetricsMasterClientServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Clears the metrics in the cluster.
     * </pre>
     */
    public void clearMetrics(alluxio.grpc.ClearMetricsPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.ClearMetricsPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getClearMetricsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Periodic metrics master client heartbeat.
     * </pre>
     */
    public void metricsHeartbeat(alluxio.grpc.MetricsHeartbeatPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.MetricsHeartbeatPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getMetricsHeartbeatMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Returns a map of metrics property names and their values from Alluxio metrics system.
     * </pre>
     */
    public void getMetrics(alluxio.grpc.GetMetricsPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetMetricsPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetMetricsMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service MetricsMasterClientService.
   * <pre>
   **
   * This interface contains metrics master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class MetricsMasterClientServiceBlockingStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractBlockingStub<MetricsMasterClientServiceBlockingStub> {
    private MetricsMasterClientServiceBlockingStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MetricsMasterClientServiceBlockingStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new MetricsMasterClientServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Clears the metrics in the cluster.
     * </pre>
     */
    public alluxio.grpc.ClearMetricsPResponse clearMetrics(alluxio.grpc.ClearMetricsPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getClearMetricsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Periodic metrics master client heartbeat.
     * </pre>
     */
    public alluxio.grpc.MetricsHeartbeatPResponse metricsHeartbeat(alluxio.grpc.MetricsHeartbeatPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getMetricsHeartbeatMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Returns a map of metrics property names and their values from Alluxio metrics system.
     * </pre>
     */
    public alluxio.grpc.GetMetricsPResponse getMetrics(alluxio.grpc.GetMetricsPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetMetricsMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service MetricsMasterClientService.
   * <pre>
   **
   * This interface contains metrics master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class MetricsMasterClientServiceFutureStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractFutureStub<MetricsMasterClientServiceFutureStub> {
    private MetricsMasterClientServiceFutureStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MetricsMasterClientServiceFutureStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new MetricsMasterClientServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Clears the metrics in the cluster.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.ClearMetricsPResponse> clearMetrics(
        alluxio.grpc.ClearMetricsPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getClearMetricsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Periodic metrics master client heartbeat.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.MetricsHeartbeatPResponse> metricsHeartbeat(
        alluxio.grpc.MetricsHeartbeatPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getMetricsHeartbeatMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Returns a map of metrics property names and their values from Alluxio metrics system.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetMetricsPResponse> getMetrics(
        alluxio.grpc.GetMetricsPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetMetricsMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_CLEAR_METRICS = 0;
  private static final int METHODID_METRICS_HEARTBEAT = 1;
  private static final int METHODID_GET_METRICS = 2;

  private static final class MethodHandlers<Req, Resp> implements
      alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_CLEAR_METRICS:
          serviceImpl.clearMetrics((alluxio.grpc.ClearMetricsPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.ClearMetricsPResponse>) responseObserver);
          break;
        case METHODID_METRICS_HEARTBEAT:
          serviceImpl.metricsHeartbeat((alluxio.grpc.MetricsHeartbeatPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.MetricsHeartbeatPResponse>) responseObserver);
          break;
        case METHODID_GET_METRICS:
          serviceImpl.getMetrics((alluxio.grpc.GetMetricsPOptions) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetMetricsPResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(
        alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getClearMetricsMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.ClearMetricsPRequest,
              alluxio.grpc.ClearMetricsPResponse>(
                service, METHODID_CLEAR_METRICS)))
        .addMethod(
          getMetricsHeartbeatMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.MetricsHeartbeatPRequest,
              alluxio.grpc.MetricsHeartbeatPResponse>(
                service, METHODID_METRICS_HEARTBEAT)))
        .addMethod(
          getGetMetricsMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.GetMetricsPOptions,
              alluxio.grpc.GetMetricsPResponse>(
                service, METHODID_GET_METRICS)))
        .build();
  }

  private static abstract class MetricsMasterClientServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoFileDescriptorSupplier, alluxio.shaded.client.io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    MetricsMasterClientServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return alluxio.grpc.MetricMasterProto.getDescriptor();
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("MetricsMasterClientService");
    }
  }

  private static final class MetricsMasterClientServiceFileDescriptorSupplier
      extends MetricsMasterClientServiceBaseDescriptorSupplier {
    MetricsMasterClientServiceFileDescriptorSupplier() {}
  }

  private static final class MetricsMasterClientServiceMethodDescriptorSupplier
      extends MetricsMasterClientServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    MetricsMasterClientServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile alluxio.shaded.client.io.grpc.ServiceDescriptor serviceDescriptor;

  public static alluxio.shaded.client.io.grpc.ServiceDescriptor getServiceDescriptor() {
    alluxio.shaded.client.io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (MetricsMasterClientServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = alluxio.shaded.client.io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new MetricsMasterClientServiceFileDescriptorSupplier())
              .addMethod(getClearMetricsMethod())
              .addMethod(getMetricsHeartbeatMethod())
              .addMethod(getGetMetricsMethod())
              .build();
        }
      }
    }
    return result;
  }
}
