package alluxio.grpc;

import static alluxio.shaded.client.io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 **
 * This interface contains job master service endpoints for job service workers.
 * </pre>
 */
@alluxio.shaded.client.javax.annotation.Generated(
    value = "by gRPC proto alluxio.shaded.client.com.iler (version 1.54.1)",
    alluxio.shaded.client.com.ents = "Source: grpc/job_master.proto")
@alluxio.shaded.client.io.grpc.stub.annotations.GrpcGenerated
public final class JobMasterWorkerServiceGrpc {

  private JobMasterWorkerServiceGrpc() {}

  public static final String SERVICE_NAME = "alluxio.grpc.job.JobMasterWorkerService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.JobHeartbeatPRequest,
      alluxio.grpc.JobHeartbeatPResponse> getHeartbeatMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Heartbeat",
      requestType = alluxio.grpc.JobHeartbeatPRequest.class,
      responseType = alluxio.grpc.JobHeartbeatPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.JobHeartbeatPRequest,
      alluxio.grpc.JobHeartbeatPResponse> getHeartbeatMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.JobHeartbeatPRequest, alluxio.grpc.JobHeartbeatPResponse> getHeartbeatMethod;
    if ((getHeartbeatMethod = JobMasterWorkerServiceGrpc.getHeartbeatMethod) == null) {
      synchronized (JobMasterWorkerServiceGrpc.class) {
        if ((getHeartbeatMethod = JobMasterWorkerServiceGrpc.getHeartbeatMethod) == null) {
          JobMasterWorkerServiceGrpc.getHeartbeatMethod = getHeartbeatMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.JobHeartbeatPRequest, alluxio.grpc.JobHeartbeatPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Heartbeat"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.JobHeartbeatPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.JobHeartbeatPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JobMasterWorkerServiceMethodDescriptorSupplier("Heartbeat"))
              .build();
        }
      }
    }
    return getHeartbeatMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RegisterJobWorkerPRequest,
      alluxio.grpc.RegisterJobWorkerPResponse> getRegisterJobWorkerMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RegisterJobWorker",
      requestType = alluxio.grpc.RegisterJobWorkerPRequest.class,
      responseType = alluxio.grpc.RegisterJobWorkerPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RegisterJobWorkerPRequest,
      alluxio.grpc.RegisterJobWorkerPResponse> getRegisterJobWorkerMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RegisterJobWorkerPRequest, alluxio.grpc.RegisterJobWorkerPResponse> getRegisterJobWorkerMethod;
    if ((getRegisterJobWorkerMethod = JobMasterWorkerServiceGrpc.getRegisterJobWorkerMethod) == null) {
      synchronized (JobMasterWorkerServiceGrpc.class) {
        if ((getRegisterJobWorkerMethod = JobMasterWorkerServiceGrpc.getRegisterJobWorkerMethod) == null) {
          JobMasterWorkerServiceGrpc.getRegisterJobWorkerMethod = getRegisterJobWorkerMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.RegisterJobWorkerPRequest, alluxio.grpc.RegisterJobWorkerPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RegisterJobWorker"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.RegisterJobWorkerPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.RegisterJobWorkerPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JobMasterWorkerServiceMethodDescriptorSupplier("RegisterJobWorker"))
              .build();
        }
      }
    }
    return getRegisterJobWorkerMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static JobMasterWorkerServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JobMasterWorkerServiceStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JobMasterWorkerServiceStub>() {
        @java.lang.Override
        public JobMasterWorkerServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new JobMasterWorkerServiceStub(channel, callOptions);
        }
      };
    return JobMasterWorkerServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static JobMasterWorkerServiceBlockingStub newBlockingStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JobMasterWorkerServiceBlockingStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JobMasterWorkerServiceBlockingStub>() {
        @java.lang.Override
        public JobMasterWorkerServiceBlockingStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new JobMasterWorkerServiceBlockingStub(channel, callOptions);
        }
      };
    return JobMasterWorkerServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static JobMasterWorkerServiceFutureStub newFutureStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JobMasterWorkerServiceFutureStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JobMasterWorkerServiceFutureStub>() {
        @java.lang.Override
        public JobMasterWorkerServiceFutureStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new JobMasterWorkerServiceFutureStub(channel, callOptions);
        }
      };
    return JobMasterWorkerServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   **
   * This interface contains job master service endpoints for job service workers.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     **
     * Periodic worker heartbeat returns a list of alluxio.shaded.client.com.ands for the worker to execute.
     * </pre>
     */
    default void heartbeat(alluxio.grpc.JobHeartbeatPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.JobHeartbeatPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getHeartbeatMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Returns a worker id for the given network address.
     * </pre>
     */
    default void registerJobWorker(alluxio.grpc.RegisterJobWorkerPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RegisterJobWorkerPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRegisterJobWorkerMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service JobMasterWorkerService.
   * <pre>
   **
   * This interface contains job master service endpoints for job service workers.
   * </pre>
   */
  public static abstract class JobMasterWorkerServiceImplBase
      implements alluxio.shaded.client.io.grpc.BindableService, AsyncService {

    @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
      return JobMasterWorkerServiceGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service JobMasterWorkerService.
   * <pre>
   **
   * This interface contains job master service endpoints for job service workers.
   * </pre>
   */
  public static final class JobMasterWorkerServiceStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractAsyncStub<JobMasterWorkerServiceStub> {
    private JobMasterWorkerServiceStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobMasterWorkerServiceStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new JobMasterWorkerServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Periodic worker heartbeat returns a list of alluxio.shaded.client.com.ands for the worker to execute.
     * </pre>
     */
    public void heartbeat(alluxio.grpc.JobHeartbeatPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.JobHeartbeatPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getHeartbeatMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Returns a worker id for the given network address.
     * </pre>
     */
    public void registerJobWorker(alluxio.grpc.RegisterJobWorkerPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RegisterJobWorkerPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getRegisterJobWorkerMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service JobMasterWorkerService.
   * <pre>
   **
   * This interface contains job master service endpoints for job service workers.
   * </pre>
   */
  public static final class JobMasterWorkerServiceBlockingStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractBlockingStub<JobMasterWorkerServiceBlockingStub> {
    private JobMasterWorkerServiceBlockingStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobMasterWorkerServiceBlockingStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new JobMasterWorkerServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Periodic worker heartbeat returns a list of alluxio.shaded.client.com.ands for the worker to execute.
     * </pre>
     */
    public alluxio.grpc.JobHeartbeatPResponse heartbeat(alluxio.grpc.JobHeartbeatPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getHeartbeatMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Returns a worker id for the given network address.
     * </pre>
     */
    public alluxio.grpc.RegisterJobWorkerPResponse registerJobWorker(alluxio.grpc.RegisterJobWorkerPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getRegisterJobWorkerMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service JobMasterWorkerService.
   * <pre>
   **
   * This interface contains job master service endpoints for job service workers.
   * </pre>
   */
  public static final class JobMasterWorkerServiceFutureStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractFutureStub<JobMasterWorkerServiceFutureStub> {
    private JobMasterWorkerServiceFutureStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobMasterWorkerServiceFutureStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new JobMasterWorkerServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Periodic worker heartbeat returns a list of alluxio.shaded.client.com.ands for the worker to execute.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.JobHeartbeatPResponse> heartbeat(
        alluxio.grpc.JobHeartbeatPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getHeartbeatMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Returns a worker id for the given network address.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.RegisterJobWorkerPResponse> registerJobWorker(
        alluxio.grpc.RegisterJobWorkerPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getRegisterJobWorkerMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_HEARTBEAT = 0;
  private static final int METHODID_REGISTER_JOB_WORKER = 1;

  private static final class MethodHandlers<Req, Resp> implements
      alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_HEARTBEAT:
          serviceImpl.heartbeat((alluxio.grpc.JobHeartbeatPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.JobHeartbeatPResponse>) responseObserver);
          break;
        case METHODID_REGISTER_JOB_WORKER:
          serviceImpl.registerJobWorker((alluxio.grpc.RegisterJobWorkerPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RegisterJobWorkerPResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(
        alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getHeartbeatMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.JobHeartbeatPRequest,
              alluxio.grpc.JobHeartbeatPResponse>(
                service, METHODID_HEARTBEAT)))
        .addMethod(
          getRegisterJobWorkerMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.RegisterJobWorkerPRequest,
              alluxio.grpc.RegisterJobWorkerPResponse>(
                service, METHODID_REGISTER_JOB_WORKER)))
        .build();
  }

  private static abstract class JobMasterWorkerServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoFileDescriptorSupplier, alluxio.shaded.client.io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    JobMasterWorkerServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return alluxio.grpc.JobMasterProto.getDescriptor();
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("JobMasterWorkerService");
    }
  }

  private static final class JobMasterWorkerServiceFileDescriptorSupplier
      extends JobMasterWorkerServiceBaseDescriptorSupplier {
    JobMasterWorkerServiceFileDescriptorSupplier() {}
  }

  private static final class JobMasterWorkerServiceMethodDescriptorSupplier
      extends JobMasterWorkerServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    JobMasterWorkerServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile alluxio.shaded.client.io.grpc.ServiceDescriptor serviceDescriptor;

  public static alluxio.shaded.client.io.grpc.ServiceDescriptor getServiceDescriptor() {
    alluxio.shaded.client.io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (JobMasterWorkerServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = alluxio.shaded.client.io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new JobMasterWorkerServiceFileDescriptorSupplier())
              .addMethod(getHeartbeatMethod())
              .addMethod(getRegisterJobWorkerMethod())
              .build();
        }
      }
    }
    return result;
  }
}
