package alluxio.grpc;

import static alluxio.shaded.client.io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 **
 * This interface contains block master service endpoints for Alluxio clients.
 * </pre>
 */
@alluxio.shaded.client.javax.annotation.Generated(
    value = "by gRPC proto alluxio.shaded.client.com.iler (version 1.54.1)",
    alluxio.shaded.client.com.ents = "Source: grpc/block_master.proto")
@alluxio.shaded.client.io.grpc.stub.annotations.GrpcGenerated
public final class BlockMasterClientServiceGrpc {

  private BlockMasterClientServiceGrpc() {}

  public static final String SERVICE_NAME = "alluxio.grpc.block.BlockMasterClientService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetBlockInfoPRequest,
      alluxio.grpc.GetBlockInfoPResponse> getGetBlockInfoMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetBlockInfo",
      requestType = alluxio.grpc.GetBlockInfoPRequest.class,
      responseType = alluxio.grpc.GetBlockInfoPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetBlockInfoPRequest,
      alluxio.grpc.GetBlockInfoPResponse> getGetBlockInfoMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetBlockInfoPRequest, alluxio.grpc.GetBlockInfoPResponse> getGetBlockInfoMethod;
    if ((getGetBlockInfoMethod = BlockMasterClientServiceGrpc.getGetBlockInfoMethod) == null) {
      synchronized (BlockMasterClientServiceGrpc.class) {
        if ((getGetBlockInfoMethod = BlockMasterClientServiceGrpc.getGetBlockInfoMethod) == null) {
          BlockMasterClientServiceGrpc.getGetBlockInfoMethod = getGetBlockInfoMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetBlockInfoPRequest, alluxio.grpc.GetBlockInfoPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetBlockInfo"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetBlockInfoPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetBlockInfoPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new BlockMasterClientServiceMethodDescriptorSupplier("GetBlockInfo"))
              .build();
        }
      }
    }
    return getGetBlockInfoMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetBlockMasterInfoPOptions,
      alluxio.grpc.GetBlockMasterInfoPResponse> getGetBlockMasterInfoMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetBlockMasterInfo",
      requestType = alluxio.grpc.GetBlockMasterInfoPOptions.class,
      responseType = alluxio.grpc.GetBlockMasterInfoPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetBlockMasterInfoPOptions,
      alluxio.grpc.GetBlockMasterInfoPResponse> getGetBlockMasterInfoMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetBlockMasterInfoPOptions, alluxio.grpc.GetBlockMasterInfoPResponse> getGetBlockMasterInfoMethod;
    if ((getGetBlockMasterInfoMethod = BlockMasterClientServiceGrpc.getGetBlockMasterInfoMethod) == null) {
      synchronized (BlockMasterClientServiceGrpc.class) {
        if ((getGetBlockMasterInfoMethod = BlockMasterClientServiceGrpc.getGetBlockMasterInfoMethod) == null) {
          BlockMasterClientServiceGrpc.getGetBlockMasterInfoMethod = getGetBlockMasterInfoMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetBlockMasterInfoPOptions, alluxio.grpc.GetBlockMasterInfoPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetBlockMasterInfo"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetBlockMasterInfoPOptions.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetBlockMasterInfoPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new BlockMasterClientServiceMethodDescriptorSupplier("GetBlockMasterInfo"))
              .build();
        }
      }
    }
    return getGetBlockMasterInfoMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetCapacityBytesPOptions,
      alluxio.grpc.GetCapacityBytesPResponse> getGetCapacityBytesMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetCapacityBytes",
      requestType = alluxio.grpc.GetCapacityBytesPOptions.class,
      responseType = alluxio.grpc.GetCapacityBytesPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetCapacityBytesPOptions,
      alluxio.grpc.GetCapacityBytesPResponse> getGetCapacityBytesMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetCapacityBytesPOptions, alluxio.grpc.GetCapacityBytesPResponse> getGetCapacityBytesMethod;
    if ((getGetCapacityBytesMethod = BlockMasterClientServiceGrpc.getGetCapacityBytesMethod) == null) {
      synchronized (BlockMasterClientServiceGrpc.class) {
        if ((getGetCapacityBytesMethod = BlockMasterClientServiceGrpc.getGetCapacityBytesMethod) == null) {
          BlockMasterClientServiceGrpc.getGetCapacityBytesMethod = getGetCapacityBytesMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetCapacityBytesPOptions, alluxio.grpc.GetCapacityBytesPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetCapacityBytes"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetCapacityBytesPOptions.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetCapacityBytesPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new BlockMasterClientServiceMethodDescriptorSupplier("GetCapacityBytes"))
              .build();
        }
      }
    }
    return getGetCapacityBytesMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetUsedBytesPOptions,
      alluxio.grpc.GetUsedBytesPResponse> getGetUsedBytesMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetUsedBytes",
      requestType = alluxio.grpc.GetUsedBytesPOptions.class,
      responseType = alluxio.grpc.GetUsedBytesPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetUsedBytesPOptions,
      alluxio.grpc.GetUsedBytesPResponse> getGetUsedBytesMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetUsedBytesPOptions, alluxio.grpc.GetUsedBytesPResponse> getGetUsedBytesMethod;
    if ((getGetUsedBytesMethod = BlockMasterClientServiceGrpc.getGetUsedBytesMethod) == null) {
      synchronized (BlockMasterClientServiceGrpc.class) {
        if ((getGetUsedBytesMethod = BlockMasterClientServiceGrpc.getGetUsedBytesMethod) == null) {
          BlockMasterClientServiceGrpc.getGetUsedBytesMethod = getGetUsedBytesMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetUsedBytesPOptions, alluxio.grpc.GetUsedBytesPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetUsedBytes"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetUsedBytesPOptions.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetUsedBytesPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new BlockMasterClientServiceMethodDescriptorSupplier("GetUsedBytes"))
              .build();
        }
      }
    }
    return getGetUsedBytesMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetWorkerInfoListPOptions,
      alluxio.grpc.GetWorkerInfoListPResponse> getGetWorkerInfoListMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetWorkerInfoList",
      requestType = alluxio.grpc.GetWorkerInfoListPOptions.class,
      responseType = alluxio.grpc.GetWorkerInfoListPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetWorkerInfoListPOptions,
      alluxio.grpc.GetWorkerInfoListPResponse> getGetWorkerInfoListMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetWorkerInfoListPOptions, alluxio.grpc.GetWorkerInfoListPResponse> getGetWorkerInfoListMethod;
    if ((getGetWorkerInfoListMethod = BlockMasterClientServiceGrpc.getGetWorkerInfoListMethod) == null) {
      synchronized (BlockMasterClientServiceGrpc.class) {
        if ((getGetWorkerInfoListMethod = BlockMasterClientServiceGrpc.getGetWorkerInfoListMethod) == null) {
          BlockMasterClientServiceGrpc.getGetWorkerInfoListMethod = getGetWorkerInfoListMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetWorkerInfoListPOptions, alluxio.grpc.GetWorkerInfoListPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetWorkerInfoList"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetWorkerInfoListPOptions.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetWorkerInfoListPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new BlockMasterClientServiceMethodDescriptorSupplier("GetWorkerInfoList"))
              .build();
        }
      }
    }
    return getGetWorkerInfoListMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RemoveDisabledWorkerPOptions,
      alluxio.grpc.RemoveDisabledWorkerPResponse> getRemoveDisabledWorkerMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RemoveDisabledWorker",
      requestType = alluxio.grpc.RemoveDisabledWorkerPOptions.class,
      responseType = alluxio.grpc.RemoveDisabledWorkerPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RemoveDisabledWorkerPOptions,
      alluxio.grpc.RemoveDisabledWorkerPResponse> getRemoveDisabledWorkerMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RemoveDisabledWorkerPOptions, alluxio.grpc.RemoveDisabledWorkerPResponse> getRemoveDisabledWorkerMethod;
    if ((getRemoveDisabledWorkerMethod = BlockMasterClientServiceGrpc.getRemoveDisabledWorkerMethod) == null) {
      synchronized (BlockMasterClientServiceGrpc.class) {
        if ((getRemoveDisabledWorkerMethod = BlockMasterClientServiceGrpc.getRemoveDisabledWorkerMethod) == null) {
          BlockMasterClientServiceGrpc.getRemoveDisabledWorkerMethod = getRemoveDisabledWorkerMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.RemoveDisabledWorkerPOptions, alluxio.grpc.RemoveDisabledWorkerPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RemoveDisabledWorker"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.RemoveDisabledWorkerPOptions.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.RemoveDisabledWorkerPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new BlockMasterClientServiceMethodDescriptorSupplier("RemoveDisabledWorker"))
              .build();
        }
      }
    }
    return getRemoveDisabledWorkerMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetWorkerReportPOptions,
      alluxio.grpc.GetWorkerInfoListPResponse> getGetWorkerReportMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetWorkerReport",
      requestType = alluxio.grpc.GetWorkerReportPOptions.class,
      responseType = alluxio.grpc.GetWorkerInfoListPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetWorkerReportPOptions,
      alluxio.grpc.GetWorkerInfoListPResponse> getGetWorkerReportMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetWorkerReportPOptions, alluxio.grpc.GetWorkerInfoListPResponse> getGetWorkerReportMethod;
    if ((getGetWorkerReportMethod = BlockMasterClientServiceGrpc.getGetWorkerReportMethod) == null) {
      synchronized (BlockMasterClientServiceGrpc.class) {
        if ((getGetWorkerReportMethod = BlockMasterClientServiceGrpc.getGetWorkerReportMethod) == null) {
          BlockMasterClientServiceGrpc.getGetWorkerReportMethod = getGetWorkerReportMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetWorkerReportPOptions, alluxio.grpc.GetWorkerInfoListPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetWorkerReport"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetWorkerReportPOptions.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetWorkerInfoListPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new BlockMasterClientServiceMethodDescriptorSupplier("GetWorkerReport"))
              .build();
        }
      }
    }
    return getGetWorkerReportMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetWorkerLostStoragePOptions,
      alluxio.grpc.GetWorkerLostStoragePResponse> getGetWorkerLostStorageMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetWorkerLostStorage",
      requestType = alluxio.grpc.GetWorkerLostStoragePOptions.class,
      responseType = alluxio.grpc.GetWorkerLostStoragePResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetWorkerLostStoragePOptions,
      alluxio.grpc.GetWorkerLostStoragePResponse> getGetWorkerLostStorageMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetWorkerLostStoragePOptions, alluxio.grpc.GetWorkerLostStoragePResponse> getGetWorkerLostStorageMethod;
    if ((getGetWorkerLostStorageMethod = BlockMasterClientServiceGrpc.getGetWorkerLostStorageMethod) == null) {
      synchronized (BlockMasterClientServiceGrpc.class) {
        if ((getGetWorkerLostStorageMethod = BlockMasterClientServiceGrpc.getGetWorkerLostStorageMethod) == null) {
          BlockMasterClientServiceGrpc.getGetWorkerLostStorageMethod = getGetWorkerLostStorageMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetWorkerLostStoragePOptions, alluxio.grpc.GetWorkerLostStoragePResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetWorkerLostStorage"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetWorkerLostStoragePOptions.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetWorkerLostStoragePResponse.getDefaultInstance()))
              .setSchemaDescriptor(new BlockMasterClientServiceMethodDescriptorSupplier("GetWorkerLostStorage"))
              .build();
        }
      }
    }
    return getGetWorkerLostStorageMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.DecommissionWorkerPOptions,
      alluxio.grpc.DecommissionWorkerPResponse> getDecommissionWorkerMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DecommissionWorker",
      requestType = alluxio.grpc.DecommissionWorkerPOptions.class,
      responseType = alluxio.grpc.DecommissionWorkerPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.DecommissionWorkerPOptions,
      alluxio.grpc.DecommissionWorkerPResponse> getDecommissionWorkerMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.DecommissionWorkerPOptions, alluxio.grpc.DecommissionWorkerPResponse> getDecommissionWorkerMethod;
    if ((getDecommissionWorkerMethod = BlockMasterClientServiceGrpc.getDecommissionWorkerMethod) == null) {
      synchronized (BlockMasterClientServiceGrpc.class) {
        if ((getDecommissionWorkerMethod = BlockMasterClientServiceGrpc.getDecommissionWorkerMethod) == null) {
          BlockMasterClientServiceGrpc.getDecommissionWorkerMethod = getDecommissionWorkerMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.DecommissionWorkerPOptions, alluxio.grpc.DecommissionWorkerPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DecommissionWorker"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.DecommissionWorkerPOptions.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.DecommissionWorkerPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new BlockMasterClientServiceMethodDescriptorSupplier("DecommissionWorker"))
              .build();
        }
      }
    }
    return getDecommissionWorkerMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static BlockMasterClientServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<BlockMasterClientServiceStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<BlockMasterClientServiceStub>() {
        @java.lang.Override
        public BlockMasterClientServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new BlockMasterClientServiceStub(channel, callOptions);
        }
      };
    return BlockMasterClientServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static BlockMasterClientServiceBlockingStub newBlockingStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<BlockMasterClientServiceBlockingStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<BlockMasterClientServiceBlockingStub>() {
        @java.lang.Override
        public BlockMasterClientServiceBlockingStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new BlockMasterClientServiceBlockingStub(channel, callOptions);
        }
      };
    return BlockMasterClientServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static BlockMasterClientServiceFutureStub newFutureStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<BlockMasterClientServiceFutureStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<BlockMasterClientServiceFutureStub>() {
        @java.lang.Override
        public BlockMasterClientServiceFutureStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new BlockMasterClientServiceFutureStub(channel, callOptions);
        }
      };
    return BlockMasterClientServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   **
   * This interface contains block master service endpoints for Alluxio clients.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     **
     * Returns the block information for the given block id.
     * </pre>
     */
    default void getBlockInfo(alluxio.grpc.GetBlockInfoPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetBlockInfoPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetBlockInfoMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Returns block master information.
     * </pre>
     */
    default void getBlockMasterInfo(alluxio.grpc.GetBlockMasterInfoPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetBlockMasterInfoPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetBlockMasterInfoMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Returns the capacity (in bytes).
     * </pre>
     */
    default void getCapacityBytes(alluxio.grpc.GetCapacityBytesPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetCapacityBytesPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetCapacityBytesMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Returns the used storage (in bytes).
     * </pre>
     */
    default void getUsedBytes(alluxio.grpc.GetUsedBytesPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetUsedBytesPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetUsedBytesMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Returns a list of workers information.
     * </pre>
     */
    default void getWorkerInfoList(alluxio.grpc.GetWorkerInfoListPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetWorkerInfoListPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetWorkerInfoListMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * If target worker is in the decommissioned worker set,
     * return true, remove target worker from decommissioned worker set; else, return false.
     * </pre>
     */
    default void removeDisabledWorker(alluxio.grpc.RemoveDisabledWorkerPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RemoveDisabledWorkerPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRemoveDisabledWorkerMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Returns a list of workers information for report CLI.
     * </pre>
     */
    default void getWorkerReport(alluxio.grpc.GetWorkerReportPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetWorkerInfoListPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetWorkerReportMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Returns a list of worker lost storage information
     * </pre>
     */
    default void getWorkerLostStorage(alluxio.grpc.GetWorkerLostStoragePOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetWorkerLostStoragePResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetWorkerLostStorageMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     *  Decommission the specific worker from Alluxio.
     * </pre>
     */
    default void decommissionWorker(alluxio.grpc.DecommissionWorkerPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.DecommissionWorkerPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getDecommissionWorkerMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service BlockMasterClientService.
   * <pre>
   **
   * This interface contains block master service endpoints for Alluxio clients.
   * </pre>
   */
  public static abstract class BlockMasterClientServiceImplBase
      implements alluxio.shaded.client.io.grpc.BindableService, AsyncService {

    @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
      return BlockMasterClientServiceGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service BlockMasterClientService.
   * <pre>
   **
   * This interface contains block master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class BlockMasterClientServiceStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractAsyncStub<BlockMasterClientServiceStub> {
    private BlockMasterClientServiceStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected BlockMasterClientServiceStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new BlockMasterClientServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Returns the block information for the given block id.
     * </pre>
     */
    public void getBlockInfo(alluxio.grpc.GetBlockInfoPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetBlockInfoPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetBlockInfoMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Returns block master information.
     * </pre>
     */
    public void getBlockMasterInfo(alluxio.grpc.GetBlockMasterInfoPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetBlockMasterInfoPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetBlockMasterInfoMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Returns the capacity (in bytes).
     * </pre>
     */
    public void getCapacityBytes(alluxio.grpc.GetCapacityBytesPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetCapacityBytesPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetCapacityBytesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Returns the used storage (in bytes).
     * </pre>
     */
    public void getUsedBytes(alluxio.grpc.GetUsedBytesPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetUsedBytesPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetUsedBytesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Returns a list of workers information.
     * </pre>
     */
    public void getWorkerInfoList(alluxio.grpc.GetWorkerInfoListPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetWorkerInfoListPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetWorkerInfoListMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * If target worker is in the decommissioned worker set,
     * return true, remove target worker from decommissioned worker set; else, return false.
     * </pre>
     */
    public void removeDisabledWorker(alluxio.grpc.RemoveDisabledWorkerPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RemoveDisabledWorkerPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getRemoveDisabledWorkerMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Returns a list of workers information for report CLI.
     * </pre>
     */
    public void getWorkerReport(alluxio.grpc.GetWorkerReportPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetWorkerInfoListPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetWorkerReportMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Returns a list of worker lost storage information
     * </pre>
     */
    public void getWorkerLostStorage(alluxio.grpc.GetWorkerLostStoragePOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetWorkerLostStoragePResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetWorkerLostStorageMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     *  Decommission the specific worker from Alluxio.
     * </pre>
     */
    public void decommissionWorker(alluxio.grpc.DecommissionWorkerPOptions request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.DecommissionWorkerPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getDecommissionWorkerMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service BlockMasterClientService.
   * <pre>
   **
   * This interface contains block master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class BlockMasterClientServiceBlockingStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractBlockingStub<BlockMasterClientServiceBlockingStub> {
    private BlockMasterClientServiceBlockingStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected BlockMasterClientServiceBlockingStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new BlockMasterClientServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Returns the block information for the given block id.
     * </pre>
     */
    public alluxio.grpc.GetBlockInfoPResponse getBlockInfo(alluxio.grpc.GetBlockInfoPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetBlockInfoMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Returns block master information.
     * </pre>
     */
    public alluxio.grpc.GetBlockMasterInfoPResponse getBlockMasterInfo(alluxio.grpc.GetBlockMasterInfoPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetBlockMasterInfoMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Returns the capacity (in bytes).
     * </pre>
     */
    public alluxio.grpc.GetCapacityBytesPResponse getCapacityBytes(alluxio.grpc.GetCapacityBytesPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetCapacityBytesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Returns the used storage (in bytes).
     * </pre>
     */
    public alluxio.grpc.GetUsedBytesPResponse getUsedBytes(alluxio.grpc.GetUsedBytesPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetUsedBytesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Returns a list of workers information.
     * </pre>
     */
    public alluxio.grpc.GetWorkerInfoListPResponse getWorkerInfoList(alluxio.grpc.GetWorkerInfoListPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetWorkerInfoListMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * If target worker is in the decommissioned worker set,
     * return true, remove target worker from decommissioned worker set; else, return false.
     * </pre>
     */
    public alluxio.grpc.RemoveDisabledWorkerPResponse removeDisabledWorker(alluxio.grpc.RemoveDisabledWorkerPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getRemoveDisabledWorkerMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Returns a list of workers information for report CLI.
     * </pre>
     */
    public alluxio.grpc.GetWorkerInfoListPResponse getWorkerReport(alluxio.grpc.GetWorkerReportPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetWorkerReportMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Returns a list of worker lost storage information
     * </pre>
     */
    public alluxio.grpc.GetWorkerLostStoragePResponse getWorkerLostStorage(alluxio.grpc.GetWorkerLostStoragePOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetWorkerLostStorageMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     *  Decommission the specific worker from Alluxio.
     * </pre>
     */
    public alluxio.grpc.DecommissionWorkerPResponse decommissionWorker(alluxio.grpc.DecommissionWorkerPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getDecommissionWorkerMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service BlockMasterClientService.
   * <pre>
   **
   * This interface contains block master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class BlockMasterClientServiceFutureStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractFutureStub<BlockMasterClientServiceFutureStub> {
    private BlockMasterClientServiceFutureStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected BlockMasterClientServiceFutureStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new BlockMasterClientServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Returns the block information for the given block id.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetBlockInfoPResponse> getBlockInfo(
        alluxio.grpc.GetBlockInfoPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetBlockInfoMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Returns block master information.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetBlockMasterInfoPResponse> getBlockMasterInfo(
        alluxio.grpc.GetBlockMasterInfoPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetBlockMasterInfoMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Returns the capacity (in bytes).
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetCapacityBytesPResponse> getCapacityBytes(
        alluxio.grpc.GetCapacityBytesPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetCapacityBytesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Returns the used storage (in bytes).
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetUsedBytesPResponse> getUsedBytes(
        alluxio.grpc.GetUsedBytesPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetUsedBytesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Returns a list of workers information.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetWorkerInfoListPResponse> getWorkerInfoList(
        alluxio.grpc.GetWorkerInfoListPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetWorkerInfoListMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * If target worker is in the decommissioned worker set,
     * return true, remove target worker from decommissioned worker set; else, return false.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.RemoveDisabledWorkerPResponse> removeDisabledWorker(
        alluxio.grpc.RemoveDisabledWorkerPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getRemoveDisabledWorkerMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Returns a list of workers information for report CLI.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetWorkerInfoListPResponse> getWorkerReport(
        alluxio.grpc.GetWorkerReportPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetWorkerReportMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Returns a list of worker lost storage information
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetWorkerLostStoragePResponse> getWorkerLostStorage(
        alluxio.grpc.GetWorkerLostStoragePOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetWorkerLostStorageMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     *  Decommission the specific worker from Alluxio.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.DecommissionWorkerPResponse> decommissionWorker(
        alluxio.grpc.DecommissionWorkerPOptions request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getDecommissionWorkerMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_BLOCK_INFO = 0;
  private static final int METHODID_GET_BLOCK_MASTER_INFO = 1;
  private static final int METHODID_GET_CAPACITY_BYTES = 2;
  private static final int METHODID_GET_USED_BYTES = 3;
  private static final int METHODID_GET_WORKER_INFO_LIST = 4;
  private static final int METHODID_REMOVE_DISABLED_WORKER = 5;
  private static final int METHODID_GET_WORKER_REPORT = 6;
  private static final int METHODID_GET_WORKER_LOST_STORAGE = 7;
  private static final int METHODID_DECOMMISSION_WORKER = 8;

  private static final class MethodHandlers<Req, Resp> implements
      alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_BLOCK_INFO:
          serviceImpl.getBlockInfo((alluxio.grpc.GetBlockInfoPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetBlockInfoPResponse>) responseObserver);
          break;
        case METHODID_GET_BLOCK_MASTER_INFO:
          serviceImpl.getBlockMasterInfo((alluxio.grpc.GetBlockMasterInfoPOptions) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetBlockMasterInfoPResponse>) responseObserver);
          break;
        case METHODID_GET_CAPACITY_BYTES:
          serviceImpl.getCapacityBytes((alluxio.grpc.GetCapacityBytesPOptions) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetCapacityBytesPResponse>) responseObserver);
          break;
        case METHODID_GET_USED_BYTES:
          serviceImpl.getUsedBytes((alluxio.grpc.GetUsedBytesPOptions) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetUsedBytesPResponse>) responseObserver);
          break;
        case METHODID_GET_WORKER_INFO_LIST:
          serviceImpl.getWorkerInfoList((alluxio.grpc.GetWorkerInfoListPOptions) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetWorkerInfoListPResponse>) responseObserver);
          break;
        case METHODID_REMOVE_DISABLED_WORKER:
          serviceImpl.removeDisabledWorker((alluxio.grpc.RemoveDisabledWorkerPOptions) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RemoveDisabledWorkerPResponse>) responseObserver);
          break;
        case METHODID_GET_WORKER_REPORT:
          serviceImpl.getWorkerReport((alluxio.grpc.GetWorkerReportPOptions) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetWorkerInfoListPResponse>) responseObserver);
          break;
        case METHODID_GET_WORKER_LOST_STORAGE:
          serviceImpl.getWorkerLostStorage((alluxio.grpc.GetWorkerLostStoragePOptions) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetWorkerLostStoragePResponse>) responseObserver);
          break;
        case METHODID_DECOMMISSION_WORKER:
          serviceImpl.decommissionWorker((alluxio.grpc.DecommissionWorkerPOptions) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.DecommissionWorkerPResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(
        alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getGetBlockInfoMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.GetBlockInfoPRequest,
              alluxio.grpc.GetBlockInfoPResponse>(
                service, METHODID_GET_BLOCK_INFO)))
        .addMethod(
          getGetBlockMasterInfoMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.GetBlockMasterInfoPOptions,
              alluxio.grpc.GetBlockMasterInfoPResponse>(
                service, METHODID_GET_BLOCK_MASTER_INFO)))
        .addMethod(
          getGetCapacityBytesMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.GetCapacityBytesPOptions,
              alluxio.grpc.GetCapacityBytesPResponse>(
                service, METHODID_GET_CAPACITY_BYTES)))
        .addMethod(
          getGetUsedBytesMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.GetUsedBytesPOptions,
              alluxio.grpc.GetUsedBytesPResponse>(
                service, METHODID_GET_USED_BYTES)))
        .addMethod(
          getGetWorkerInfoListMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.GetWorkerInfoListPOptions,
              alluxio.grpc.GetWorkerInfoListPResponse>(
                service, METHODID_GET_WORKER_INFO_LIST)))
        .addMethod(
          getRemoveDisabledWorkerMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.RemoveDisabledWorkerPOptions,
              alluxio.grpc.RemoveDisabledWorkerPResponse>(
                service, METHODID_REMOVE_DISABLED_WORKER)))
        .addMethod(
          getGetWorkerReportMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.GetWorkerReportPOptions,
              alluxio.grpc.GetWorkerInfoListPResponse>(
                service, METHODID_GET_WORKER_REPORT)))
        .addMethod(
          getGetWorkerLostStorageMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.GetWorkerLostStoragePOptions,
              alluxio.grpc.GetWorkerLostStoragePResponse>(
                service, METHODID_GET_WORKER_LOST_STORAGE)))
        .addMethod(
          getDecommissionWorkerMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.DecommissionWorkerPOptions,
              alluxio.grpc.DecommissionWorkerPResponse>(
                service, METHODID_DECOMMISSION_WORKER)))
        .build();
  }

  private static abstract class BlockMasterClientServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoFileDescriptorSupplier, alluxio.shaded.client.io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    BlockMasterClientServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return alluxio.grpc.BlockMasterProto.getDescriptor();
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("BlockMasterClientService");
    }
  }

  private static final class BlockMasterClientServiceFileDescriptorSupplier
      extends BlockMasterClientServiceBaseDescriptorSupplier {
    BlockMasterClientServiceFileDescriptorSupplier() {}
  }

  private static final class BlockMasterClientServiceMethodDescriptorSupplier
      extends BlockMasterClientServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    BlockMasterClientServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile alluxio.shaded.client.io.grpc.ServiceDescriptor serviceDescriptor;

  public static alluxio.shaded.client.io.grpc.ServiceDescriptor getServiceDescriptor() {
    alluxio.shaded.client.io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (BlockMasterClientServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = alluxio.shaded.client.io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new BlockMasterClientServiceFileDescriptorSupplier())
              .addMethod(getGetBlockInfoMethod())
              .addMethod(getGetBlockMasterInfoMethod())
              .addMethod(getGetCapacityBytesMethod())
              .addMethod(getGetUsedBytesMethod())
              .addMethod(getGetWorkerInfoListMethod())
              .addMethod(getRemoveDisabledWorkerMethod())
              .addMethod(getGetWorkerReportMethod())
              .addMethod(getGetWorkerLostStorageMethod())
              .addMethod(getDecommissionWorkerMethod())
              .build();
        }
      }
    }
    return result;
  }
}
