/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Ticker;
import alluxio.util.RateLimiter;
import java.time.Duration;
import java.util.Optional;

public class SimpleRateLimiter
implements RateLimiter {
    final Ticker mTicker;
    final long mMinDuration;
    long mLastAcquire = 0L;

    SimpleRateLimiter(long permitsPerSecond) {
        this(permitsPerSecond, new Ticker(){

            @Override
            public long read() {
                return System.nanoTime();
            }
        });
    }

    @VisibleForTesting
    public SimpleRateLimiter(long permitsPerSecond, Ticker ticker) {
        this.mTicker = ticker;
        this.mMinDuration = Duration.ofSeconds(1L).toNanos() / permitsPerSecond;
    }

    @Override
    public long getWaitTimeNanos(long permit) {
        return permit - this.mTicker.read();
    }

    @Override
    public Optional<Long> acquire() {
        long nxtElapsed = this.mTicker.read();
        if (nxtElapsed - this.mLastAcquire >= this.mMinDuration) {
            this.mLastAcquire = nxtElapsed;
            return Optional.empty();
        }
        this.mLastAcquire += this.mMinDuration;
        return Optional.of(this.mLastAcquire);
    }
}

