/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CheckAccessPOptions;
import alluxio.grpc.CheckConsistencyPOptions;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.ListStatusPartialPOptions;
import alluxio.grpc.LoadDescendantPType;
import alluxio.grpc.LoadMetadataPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.MountPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.RenamePOptions;
import alluxio.grpc.ScheduleAsyncPersistencePOptions;
import alluxio.grpc.SetAclPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.SyncMetadataPOptions;
import alluxio.grpc.TtlAction;
import alluxio.grpc.UnmountPOptions;
import alluxio.security.authorization.Mode;
import alluxio.util.ModeUtils;
import alluxio.wire.OperationId;
import java.util.UUID;

public class FileSystemOptionsUtils {
    public static ScheduleAsyncPersistencePOptions scheduleAsyncPersistenceDefaults(AlluxioConfiguration conf) {
        return ScheduleAsyncPersistencePOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf)).setPersistenceWaitTime(0L).build();
    }

    public static CreateDirectoryPOptions createDirectoryDefaults(AlluxioConfiguration conf) {
        return FileSystemOptionsUtils.createDirectoryDefaults(conf, true);
    }

    public static CreateDirectoryPOptions createDirectoryDefaults(AlluxioConfiguration conf, boolean withOpId) {
        return CreateDirectoryPOptions.newBuilder().setAllowExists(false).setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf, withOpId)).setMode(ModeUtils.applyDirectoryUMask(Mode.defaults(), conf.getString(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK)).toProto()).setRecursive(false).setWriteType(conf.getEnum(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.class).toProto()).build();
    }

    public static CheckAccessPOptions checkAccessDefaults(AlluxioConfiguration conf) {
        return CheckAccessPOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf)).build();
    }

    public static CheckConsistencyPOptions checkConsistencyDefaults(AlluxioConfiguration conf) {
        return CheckConsistencyPOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf)).build();
    }

    public static CreateFilePOptions createFileDefaults(AlluxioConfiguration conf) {
        return FileSystemOptionsUtils.createFileDefaults(conf, true);
    }

    public static CreateFilePOptions createFileDefaults(AlluxioConfiguration conf, boolean withOpId) {
        return CreateFilePOptions.newBuilder().setBlockSizeBytes(conf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT)).setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf, withOpId)).setMode(ModeUtils.applyFileUMask(Mode.defaults(), conf.getString(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK)).toProto()).setPersistenceWaitTime(conf.getMs(PropertyKey.USER_FILE_PERSISTENCE_INITIAL_WAIT_TIME)).setRecursive(false).setReplicationDurable(conf.getInt(PropertyKey.USER_FILE_REPLICATION_DURABLE)).setReplicationMax(conf.getInt(PropertyKey.USER_FILE_REPLICATION_MAX)).setReplicationMin(conf.getInt(PropertyKey.USER_FILE_REPLICATION_MIN)).setWriteTier(conf.getInt(PropertyKey.USER_FILE_WRITE_TIER_DEFAULT)).setWriteType(conf.getEnum(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.class).toProto()).build();
    }

    public static DeletePOptions deleteDefaults(AlluxioConfiguration conf) {
        return FileSystemOptionsUtils.deleteDefaults(conf, true);
    }

    public static DeletePOptions deleteDefaults(AlluxioConfiguration conf, boolean withOpId) {
        return DeletePOptions.newBuilder().setAlluxioOnly(false).setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf, withOpId)).setRecursive(false).setUnchecked(conf.getBoolean(PropertyKey.USER_FILE_DELETE_UNCHECKED)).build();
    }

    public static ExistsPOptions existsDefaults(AlluxioConfiguration conf) {
        return ExistsPOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf)).setLoadMetadataType(conf.getEnum(PropertyKey.USER_FILE_METADATA_LOAD_TYPE, LoadMetadataPType.class)).build();
    }

    public static SyncMetadataPOptions syncMetadataDefaults(AlluxioConfiguration conf) {
        return SyncMetadataPOptions.newBuilder().build();
    }

    public static FileSystemMasterCommonPOptions commonDefaults(AlluxioConfiguration conf) {
        return FileSystemOptionsUtils.commonDefaults(conf, false);
    }

    public static FileSystemMasterCommonPOptions commonDefaults(AlluxioConfiguration conf, boolean withOpId) {
        FileSystemMasterCommonPOptions.Builder builder = FileSystemMasterCommonPOptions.newBuilder().setTtl(conf.getMs(PropertyKey.USER_FILE_CREATE_TTL)).setTtlAction(conf.getEnum(PropertyKey.USER_FILE_CREATE_TTL_ACTION, TtlAction.class));
        if (withOpId && conf.getBoolean(PropertyKey.USER_FILE_INCLUDE_OPERATION_ID)) {
            builder.setOperationId(new OperationId(UUID.randomUUID()).toFsProto());
        }
        if (conf.isSetByUser(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL)) {
            builder.setSyncIntervalMs(conf.getMs(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL));
        }
        return builder.build();
    }

    public static FreePOptions freeDefaults(AlluxioConfiguration conf) {
        return FreePOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf)).setForced(false).setRecursive(false).build();
    }

    public static GetStatusPOptions getStatusDefaults(AlluxioConfiguration conf) {
        return GetStatusPOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf)).setLoadMetadataType(conf.getEnum(PropertyKey.USER_FILE_METADATA_LOAD_TYPE, LoadMetadataPType.class)).build();
    }

    public static ListStatusPOptions listStatusDefaults(AlluxioConfiguration conf) {
        return ListStatusPOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf)).setLoadMetadataType(conf.getEnum(PropertyKey.USER_FILE_METADATA_LOAD_TYPE, LoadMetadataPType.class)).setLoadMetadataOnly(false).build();
    }

    public static ListStatusPartialPOptions listStatusPartialDefaults(AlluxioConfiguration conf) {
        return ListStatusPartialPOptions.newBuilder().setOptions(FileSystemOptionsUtils.listStatusDefaults(conf)).build();
    }

    public static LoadMetadataPOptions loadMetadataDefaults(AlluxioConfiguration conf) {
        return LoadMetadataPOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf)).setCreateAncestors(false).setLoadDescendantType(LoadDescendantPType.NONE).setRecursive(false).build();
    }

    public static MountPOptions mountDefaults(AlluxioConfiguration conf) {
        return MountPOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf)).setReadOnly(false).setShared(false).build();
    }

    public static OpenFilePOptions openFileDefaults(AlluxioConfiguration conf) {
        return OpenFilePOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf)).setMaxUfsReadConcurrency(conf.getInt(PropertyKey.USER_UFS_BLOCK_READ_CONCURRENCY_MAX)).setReadType(conf.getEnum(PropertyKey.USER_FILE_READ_TYPE_DEFAULT, ReadType.class).toProto()).build();
    }

    public static RenamePOptions renameDefaults(AlluxioConfiguration conf) {
        return FileSystemOptionsUtils.renameDefaults(conf, true);
    }

    public static RenamePOptions renameDefaults(AlluxioConfiguration conf, boolean withOpId) {
        return RenamePOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf, withOpId)).setPersist(conf.getBoolean(PropertyKey.USER_FILE_PERSIST_ON_RENAME)).build();
    }

    public static ScheduleAsyncPersistencePOptions scheduleAsyncPersistDefaults(AlluxioConfiguration conf) {
        return ScheduleAsyncPersistencePOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf)).build();
    }

    public static SetAclPOptions setAclDefaults(AlluxioConfiguration conf) {
        return SetAclPOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf)).setRecursive(false).build();
    }

    public static SetAttributePOptions setAttributeDefaults(AlluxioConfiguration conf) {
        return SetAttributePOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf)).setRecursive(false).build();
    }

    public static SetAttributePOptions setAttributeClientDefaults(AlluxioConfiguration conf) {
        FileSystemMasterCommonPOptions.Builder builder = FileSystemMasterCommonPOptions.newBuilder();
        if (conf.isSetByUser(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL)) {
            builder.setSyncIntervalMs(conf.getMs(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL));
        }
        return SetAttributePOptions.newBuilder().setCommonOptions(builder.build()).build();
    }

    public static UnmountPOptions unmountDefaults(AlluxioConfiguration conf) {
        return UnmountPOptions.newBuilder().setCommonOptions(FileSystemOptionsUtils.commonDefaults(conf)).build();
    }
}

