/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.group;

import alluxio.security.group.GroupMappingService;
import alluxio.shaded.client.com.google.common.cache.CacheBuilder;
import alluxio.shaded.client.com.google.common.cache.CacheLoader;
import alluxio.shaded.client.com.google.common.cache.LoadingCache;
import alluxio.shaded.client.com.google.common.util.concurrent.ListenableFuture;
import alluxio.shaded.client.com.google.common.util.concurrent.ListeningExecutorService;
import alluxio.shaded.client.com.google.common.util.concurrent.MoreExecutors;
import alluxio.shaded.client.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class CachedGroupMapping
implements GroupMappingService {
    private final GroupMappingService mService;
    private final boolean mCacheEnabled;
    private LoadingCache<String, List<String>> mCache;
    private static final long MAXSIZE = 10000L;
    private final ThreadFactory mThreadFactory = new ThreadFactoryBuilder().setNameFormat("UserGroupMappingCachePool-%d").setDaemon(true).build();
    private final ExecutorService mParentExecutor = Executors.newSingleThreadExecutor(this.mThreadFactory);
    private final ListeningExecutorService mExecutorService = MoreExecutors.listeningDecorator(this.mParentExecutor);

    public CachedGroupMapping(GroupMappingService service, long groupMappingCacheTimeoutMs) {
        this.mService = service;
        boolean bl = this.mCacheEnabled = groupMappingCacheTimeoutMs > 0L;
        if (this.mCacheEnabled) {
            this.mCache = CacheBuilder.newBuilder().maximumSize(10000L).refreshAfterWrite(groupMappingCacheTimeoutMs, TimeUnit.MILLISECONDS).expireAfterWrite(10L * groupMappingCacheTimeoutMs, TimeUnit.MILLISECONDS).build(new GroupMappingCacheLoader());
        }
    }

    @Override
    public List<String> getGroups(String user) throws IOException {
        if (!this.mCacheEnabled) {
            return this.mService.getGroups(user);
        }
        try {
            return this.mCache.get(user);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    private class GroupMappingCacheLoader
    extends CacheLoader<String, List<String>> {
        @Override
        public List<String> load(String user) throws IOException {
            return CachedGroupMapping.this.mService.getGroups(user);
        }

        @Override
        public ListenableFuture<List<String>> reload(String user, List<String> oldValue) throws IOException {
            Future listenableFuture = CachedGroupMapping.this.mExecutorService.submit(() -> this.load(user));
            return listenableFuture;
        }
    }
}

