/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.conf.PropertyKey;
import alluxio.conf.Reconfigurable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ReconfigurableRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ReconfigurableRegistry.class);
    private static final List<Reconfigurable> LISTENER_LIST = new LinkedList<Reconfigurable>();

    public static synchronized void register(Reconfigurable listener) {
        LISTENER_LIST.add(listener);
    }

    public static synchronized boolean unregister(Reconfigurable listener) {
        return LISTENER_LIST.remove(listener);
    }

    public static synchronized boolean update() {
        for (Reconfigurable listener : LISTENER_LIST) {
            try {
                listener.update();
            }
            catch (Throwable t) {
                LOG.error("Error while update changed properties for {}", (Object)listener, (Object)t);
            }
        }
        return true;
    }

    private ReconfigurableRegistry() {
    }

    public static synchronized void update(Map<PropertyKey, Object> changedProperties) {
        for (Reconfigurable listener : LISTENER_LIST) {
            try {
                listener.update(changedProperties);
            }
            catch (Throwable t) {
                LOG.error("Error while update changed properties {} for {}", new Object[]{changedProperties, listener, t});
            }
        }
    }
}

