/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.ufs;

import alluxio.client.file.FileOutStream;
import alluxio.exception.PreconditionMessage;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.io.IOException;
import java.io.OutputStream;

@ThreadSafe
public class UfsFileOutStream
extends FileOutStream {
    private final Closer mCloser = Closer.create();
    private final OutputStream mUfsOutStream;

    public UfsFileOutStream(OutputStream stream) {
        this.mUfsOutStream = Preconditions.checkNotNull(stream);
        this.mCloser.register(this.mUfsOutStream);
    }

    @Override
    public synchronized long getBytesWritten() {
        return this.mBytesWritten;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.mUfsOutStream.write(b);
        ++this.mBytesWritten;
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        Preconditions.checkArgument(b != null, (Object)PreconditionMessage.ERR_WRITE_BUFFER_NULL);
        this.mUfsOutStream.write(b);
        this.mBytesWritten += (long)b.length;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        Preconditions.checkArgument(off >= 0 && len >= 0 && len + off <= b.length, PreconditionMessage.ERR_BUFFER_STATE.toString(), (Object)b.length, (Object)off, (Object)len);
        this.mUfsOutStream.write(b, off, len);
        this.mBytesWritten += (long)len;
    }

    @Override
    public synchronized void cancel() {
    }

    @Override
    public synchronized void close() throws IOException {
        this.mCloser.close();
    }
}

