/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.AlluxioURI;
import alluxio.SyncInfo;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.UnimplementedException;
import alluxio.metrics.Metric;
import alluxio.metrics.MetricsSystem;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.shaded.client.com.codahale.metrics.Timer;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.underfs.Fingerprint;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsMode;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.FileLocationOptions;
import alluxio.underfs.options.ListOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.SecurityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnderFileSystemWithLogging
implements UnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(UnderFileSystemWithLogging.class);
    private static final String NAME_SEPARATOR = ":";
    private final UnderFileSystem mUnderFileSystem;
    private final UnderFileSystemConfiguration mConf;
    private final String mPath;
    private final String mEscapedPath;
    private final long mLoggingThreshold;

    UnderFileSystemWithLogging(String path, UnderFileSystem ufs, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull(path, "path");
        this.mPath = path;
        this.mUnderFileSystem = ufs;
        this.mConf = conf;
        this.mEscapedPath = MetricsSystem.escape(new AlluxioURI(path));
        this.mLoggingThreshold = this.mConf.getMs(PropertyKey.UNDERFS_LOGGING_THRESHOLD);
    }

    @Override
    public void cleanup() throws IOException {
        this.call(new UfsCallable<Void>(){

            @Override
            public Void call() throws IOException {
                UnderFileSystemWithLogging.this.mUnderFileSystem.cleanup();
                return null;
            }

            @Override
            public String methodName() {
                return "cleanup";
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.call(new UfsCallable<Void>(){

            @Override
            public Void call() throws IOException {
                UnderFileSystemWithLogging.this.mUnderFileSystem.close();
                return null;
            }

            @Override
            public String methodName() {
                return "close";
            }
        });
    }

    @Override
    public void connectFromMaster(final String hostname) throws IOException {
        this.call(new UfsCallable<Void>(){

            @Override
            public Void call() throws IOException {
                UnderFileSystemWithLogging.this.mUnderFileSystem.connectFromMaster(hostname);
                return null;
            }

            @Override
            public String methodName() {
                return "ConnectFromMaster";
            }

            @Override
            public String toString() {
                return String.format("hostname=%s", hostname);
            }
        });
    }

    @Override
    public void connectFromWorker(final String hostname) throws IOException {
        this.call(new UfsCallable<Void>(){

            @Override
            public Void call() throws IOException {
                UnderFileSystemWithLogging.this.mUnderFileSystem.connectFromWorker(hostname);
                return null;
            }

            @Override
            public String methodName() {
                return "ConnectFromWorker";
            }

            @Override
            public String toString() {
                return String.format("hostname=%s", hostname);
            }
        });
    }

    @Override
    public OutputStream create(final String path) throws IOException {
        return this.call(new UfsCallable<OutputStream>(){

            @Override
            public OutputStream call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.create(path);
            }

            @Override
            public String methodName() {
                return "Create";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public OutputStream create(final String path, final CreateOptions options) throws IOException {
        return this.call(new UfsCallable<OutputStream>(){

            @Override
            public OutputStream call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.create(path, options);
            }

            @Override
            public String methodName() {
                return "Create";
            }

            @Override
            public String toString() {
                return String.format("path=%s, options=%s", path, options);
            }
        });
    }

    @Override
    public OutputStream createNonexistingFile(final String path) throws IOException {
        return this.call(new UfsCallable<OutputStream>(){

            @Override
            public OutputStream call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.createNonexistingFile(path);
            }

            @Override
            public String methodName() {
                return "CreateNonexistingFile";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public OutputStream createNonexistingFile(final String path, final CreateOptions options) throws IOException {
        return this.call(new UfsCallable<OutputStream>(){

            @Override
            public OutputStream call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.createNonexistingFile(path, options);
            }

            @Override
            public String methodName() {
                return "CreateNonexistingFile";
            }

            @Override
            public String toString() {
                return String.format("path=%s, options=%s", path, options);
            }
        });
    }

    @Override
    public boolean deleteDirectory(final String path) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.deleteDirectory(path);
            }

            @Override
            public String methodName() {
                return "DeleteDirectory";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public boolean deleteDirectory(final String path, final DeleteOptions options) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.deleteDirectory(path, options);
            }

            @Override
            public String methodName() {
                return "DeleteDirectory";
            }

            @Override
            public String toString() {
                return String.format("path=%s, options=%s", path, options);
            }
        });
    }

    @Override
    public boolean deleteExistingDirectory(final String path) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.deleteExistingDirectory(path);
            }

            @Override
            public String methodName() {
                return "DeleteExistingDirectory";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public boolean deleteExistingDirectory(final String path, final DeleteOptions options) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.deleteExistingDirectory(path, options);
            }

            @Override
            public String methodName() {
                return "DeleteExistingDirectory";
            }

            @Override
            public String toString() {
                return String.format("path=%s, options=%s", path, options);
            }
        });
    }

    @Override
    public boolean deleteFile(final String path) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.deleteFile(path);
            }

            @Override
            public String methodName() {
                return "DeleteFile";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public boolean deleteExistingFile(final String path) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.deleteExistingFile(path);
            }

            @Override
            public String methodName() {
                return "DeleteExistingFile";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public boolean exists(final String path) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.exists(path);
            }

            @Override
            public String methodName() {
                return "Exists";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public Pair<AccessControlList, DefaultAccessControlList> getAclPair(final String path) throws IOException, UnimplementedException {
        return this.call(new UfsCallable<Pair<AccessControlList, DefaultAccessControlList>>(){

            @Override
            public Pair<AccessControlList, DefaultAccessControlList> call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.getAclPair(path);
            }

            @Override
            public String methodName() {
                return "GetAcl";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public long getBlockSizeByte(final String path) throws IOException {
        return this.call(new UfsCallable<Long>(){

            @Override
            public Long call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.getBlockSizeByte(path);
            }

            @Override
            public String methodName() {
                return "GetBlockSizeByte";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public AlluxioConfiguration getConfiguration() throws IOException {
        return this.call(new UfsCallable<AlluxioConfiguration>(){

            @Override
            public AlluxioConfiguration call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.getConfiguration();
            }

            @Override
            public String methodName() {
                return "GetConfiguration";
            }

            @Override
            public String toString() {
                return "";
            }
        });
    }

    @Override
    public UfsDirectoryStatus getDirectoryStatus(final String path) throws IOException {
        return this.call(new UfsCallable<UfsDirectoryStatus>(){

            @Override
            public UfsDirectoryStatus call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.getDirectoryStatus(path);
            }

            @Override
            public String methodName() {
                return "GetDirectoryStatus";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public UfsDirectoryStatus getExistingDirectoryStatus(final String path) throws IOException {
        return this.call(new UfsCallable<UfsDirectoryStatus>(){

            @Override
            public UfsDirectoryStatus call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.getExistingDirectoryStatus(path);
            }

            @Override
            public String methodName() {
                return "GetExistingDirectoryStatus";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public List<String> getFileLocations(final String path) throws IOException {
        return this.call(new UfsCallable<List<String>>(){

            @Override
            public List<String> call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.getFileLocations(path);
            }

            @Override
            public String methodName() {
                return "GetFileLocations";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public List<String> getFileLocations(final String path, final FileLocationOptions options) throws IOException {
        return this.call(new UfsCallable<List<String>>(){

            @Override
            public List<String> call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.getFileLocations(path, options);
            }

            @Override
            public String methodName() {
                return "GetFileLocations";
            }

            @Override
            public String toString() {
                return String.format("path=%s, options=%s", path, options);
            }
        });
    }

    @Override
    public UfsFileStatus getFileStatus(final String path) throws IOException {
        return this.call(new UfsCallable<UfsFileStatus>(){

            @Override
            public UfsFileStatus call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.getFileStatus(path);
            }

            @Override
            public String methodName() {
                return "GetFileStatus";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public UfsFileStatus getExistingFileStatus(final String path) throws IOException {
        return this.call(new UfsCallable<UfsFileStatus>(){

            @Override
            public UfsFileStatus call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.getExistingFileStatus(path);
            }

            @Override
            public String methodName() {
                return "GetExistingFileStatus";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public String getFingerprint(final String path) {
        try {
            return this.call(new UfsCallable<String>(){

                @Override
                public String call() throws IOException {
                    return UnderFileSystemWithLogging.this.mUnderFileSystem.getFingerprint(path);
                }

                @Override
                public String methodName() {
                    return "GetFingerprint";
                }

                @Override
                public String toString() {
                    return String.format("path=%s", path);
                }
            });
        }
        catch (IOException e) {
            return "";
        }
    }

    @Override
    public Fingerprint getParsedFingerprint(final String path) {
        try {
            return this.call(new UfsCallable<Fingerprint>(){

                @Override
                public Fingerprint call() throws IOException {
                    return UnderFileSystemWithLogging.this.mUnderFileSystem.getParsedFingerprint(path);
                }

                @Override
                public String methodName() {
                    return "GetParsedFingerprint";
                }

                @Override
                public String toString() {
                    return String.format("path=%s", path);
                }
            });
        }
        catch (IOException e) {
            return Fingerprint.INVALID_FINGERPRINT;
        }
    }

    @Override
    public Fingerprint getParsedFingerprint(final String path, final @Nullable String contentHash) {
        try {
            return this.call(new UfsCallable<Fingerprint>(){

                @Override
                public Fingerprint call() {
                    return UnderFileSystemWithLogging.this.mUnderFileSystem.getParsedFingerprint(path, contentHash);
                }

                @Override
                public String methodName() {
                    return "GetParsedFingerprint";
                }

                @Override
                public String toString() {
                    return String.format("path=%s, contentHash=%s", path, contentHash);
                }
            });
        }
        catch (IOException e) {
            return Fingerprint.INVALID_FINGERPRINT;
        }
    }

    @Override
    public UfsMode getOperationMode(Map<String, UfsMode> physicalUfsState) {
        return this.mUnderFileSystem.getOperationMode(physicalUfsState);
    }

    @Override
    public long getSpace(final String path, final UnderFileSystem.SpaceType type) throws IOException {
        return this.call(new UfsCallable<Long>(){

            @Override
            public Long call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.getSpace(path, type);
            }

            @Override
            public String methodName() {
                return "GetSpace";
            }

            @Override
            public String toString() {
                return String.format("path=%s, type=%s", new Object[]{path, type});
            }
        });
    }

    @Override
    public UfsStatus getStatus(final String path) throws IOException {
        return this.call(new UfsCallable<UfsStatus>(){

            @Override
            public UfsStatus call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.getStatus(path);
            }

            @Override
            public String methodName() {
                return "GetStatus";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public UfsStatus getExistingStatus(final String path) throws IOException {
        return this.call(new UfsCallable<UfsStatus>(){

            @Override
            public UfsStatus call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.getExistingStatus(path);
            }

            @Override
            public String methodName() {
                return "GetExistingStatus";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public String getUnderFSType() {
        return this.mUnderFileSystem.getUnderFSType();
    }

    @Override
    public boolean isDirectory(final String path) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.isDirectory(path);
            }

            @Override
            public String methodName() {
                return "IsDirectory";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public boolean isExistingDirectory(final String path) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.isExistingDirectory(path);
            }

            @Override
            public String methodName() {
                return "IsExistingDirectory";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public boolean isFile(final String path) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.isFile(path);
            }

            @Override
            public String methodName() {
                return "IsFile";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public List<String> getPhysicalStores() {
        return this.mUnderFileSystem.getPhysicalStores();
    }

    @Override
    public boolean isObjectStorage() {
        return this.mUnderFileSystem.isObjectStorage();
    }

    @Override
    public UfsStatus[] listStatus(final String path) throws IOException {
        return this.call(new UfsCallable<UfsStatus[]>(){

            @Override
            public UfsStatus[] call() throws IOException {
                return UnderFileSystemWithLogging.this.filterInvalidPaths(UnderFileSystemWithLogging.this.mUnderFileSystem.listStatus(path), path);
            }

            @Override
            public String methodName() {
                return "ListStatus";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public UfsStatus[] listStatus(final String path, final ListOptions options) throws IOException {
        return this.call(new UfsCallable<UfsStatus[]>(){

            @Override
            public UfsStatus[] call() throws IOException {
                return UnderFileSystemWithLogging.this.filterInvalidPaths(UnderFileSystemWithLogging.this.mUnderFileSystem.listStatus(path, options), path);
            }

            @Override
            public String methodName() {
                return "ListStatus";
            }

            @Override
            public String toString() {
                return String.format("path=%s, options=%s", path, options);
            }
        });
    }

    @Nullable
    private UfsStatus[] filterInvalidPaths(UfsStatus[] statuses, String listedPath) {
        if (statuses == null) {
            return null;
        }
        int removed = 0;
        for (UfsStatus status : statuses) {
            if (!status.getName().contains("?")) continue;
            LOG.warn("Ignoring {} while listing {} since it contains '?'", (Object)status.getName(), (Object)listedPath);
            ++removed;
        }
        if (removed > 0) {
            UfsStatus[] newStatuses = new UfsStatus[statuses.length - removed];
            int i = 0;
            for (UfsStatus status : statuses) {
                if (status.getName().contains("?")) continue;
                newStatuses[i++] = status;
            }
            return newStatuses;
        }
        return statuses;
    }

    @Override
    public boolean mkdirs(final String path) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.mkdirs(path);
            }

            @Override
            public String methodName() {
                return "Mkdirs";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public boolean mkdirs(final String path, final MkdirsOptions options) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.mkdirs(path, options);
            }

            @Override
            public String methodName() {
                return "Mkdirs";
            }

            @Override
            public String toString() {
                return String.format("path=%s, options=%s", path, options);
            }
        });
    }

    @Override
    public InputStream open(final String path) throws IOException {
        return this.call(new UfsCallable<InputStream>(){

            @Override
            public InputStream call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.open(path);
            }

            @Override
            public String methodName() {
                return "Open";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public InputStream open(final String path, final OpenOptions options) throws IOException {
        return this.call(new UfsCallable<InputStream>(){

            @Override
            public InputStream call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.open(path, options);
            }

            @Override
            public String methodName() {
                return "Open";
            }

            @Override
            public String toString() {
                return String.format("path=%s, options=%s", path, options);
            }
        });
    }

    @Override
    public InputStream openExistingFile(final String path) throws IOException {
        return this.call(new UfsCallable<InputStream>(){

            @Override
            public InputStream call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.openExistingFile(path);
            }

            @Override
            public String methodName() {
                return "OpenExistingFile";
            }

            @Override
            public String toString() {
                return String.format("path=%s", path);
            }
        });
    }

    @Override
    public InputStream openExistingFile(final String path, final OpenOptions options) throws IOException {
        return this.call(new UfsCallable<InputStream>(){

            @Override
            public InputStream call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.openExistingFile(path, options);
            }

            @Override
            public String methodName() {
                return "OpenExistingFile";
            }

            @Override
            public String toString() {
                return String.format("path=%s, options=%s", path, options);
            }
        });
    }

    @Override
    public boolean renameDirectory(final String src, final String dst) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.renameDirectory(src, dst);
            }

            @Override
            public String methodName() {
                return "RenameDirectory";
            }

            @Override
            public String toString() {
                return String.format("src=%s, dst=%s", src, dst);
            }
        });
    }

    @Override
    public boolean renameRenamableDirectory(final String src, final String dst) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.renameRenamableDirectory(src, dst);
            }

            @Override
            public String methodName() {
                return "RenameRenableDirectory";
            }

            @Override
            public String toString() {
                return String.format("src=%s, dst=%s", src, dst);
            }
        });
    }

    @Override
    public boolean renameFile(final String src, final String dst) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.renameFile(src, dst);
            }

            @Override
            public String methodName() {
                return "RenameFile";
            }

            @Override
            public String toString() {
                return String.format("src=%s, dst=%s", src, dst);
            }
        });
    }

    @Override
    public boolean renameRenamableFile(final String src, final String dst) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.renameRenamableFile(src, dst);
            }

            @Override
            public String methodName() {
                return "RenameRenamableFile";
            }

            @Override
            public String toString() {
                return String.format("src=%s, dst=%s", src, dst);
            }
        });
    }

    @Override
    public AlluxioURI resolveUri(AlluxioURI ufsBaseUri, String alluxioPath) {
        return this.mUnderFileSystem.resolveUri(ufsBaseUri, alluxioPath);
    }

    @Override
    public void setAclEntries(final String path, final List<AclEntry> aclEntries) throws IOException {
        this.call(new UfsCallable<Void>(){

            @Override
            public Void call() throws IOException {
                UnderFileSystemWithLogging.this.mUnderFileSystem.setAclEntries(path, aclEntries);
                return null;
            }

            @Override
            public String methodName() {
                return "SetAclEntries";
            }

            @Override
            public String toString() {
                return String.format("path=%s, ACLEntries=%s", path, aclEntries);
            }
        });
    }

    @Override
    public void setOwner(final String path, final String owner, final String group) throws IOException {
        this.call(new UfsCallable<Void>(){

            @Override
            public Void call() throws IOException {
                UnderFileSystemWithLogging.this.mUnderFileSystem.setOwner(path, owner, group);
                return null;
            }

            @Override
            public String methodName() {
                return "SetOwner";
            }

            @Override
            public String toString() {
                return String.format("path=%s, owner=%s, group=%s", path, owner, group);
            }
        });
    }

    @Override
    public void setMode(final String path, final short mode) throws IOException {
        this.call(new UfsCallable<Void>(){

            @Override
            public Void call() throws IOException {
                UnderFileSystemWithLogging.this.mUnderFileSystem.setMode(path, mode);
                return null;
            }

            @Override
            public String methodName() {
                return "SetMode";
            }

            @Override
            public String toString() {
                return String.format("path=%s, mode=%s", path, mode);
            }
        });
    }

    @Override
    public boolean supportsFlush() throws IOException {
        return this.mUnderFileSystem.supportsFlush();
    }

    @Override
    public boolean supportsActiveSync() {
        return this.mUnderFileSystem.supportsActiveSync();
    }

    @Override
    public boolean startActiveSyncPolling(final long txId) throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.startActiveSyncPolling(txId);
            }

            @Override
            public String methodName() {
                return "StartActiveSyncPolling";
            }

            @Override
            public String toString() {
                return String.format("txId=%d", txId);
            }
        });
    }

    @Override
    public boolean stopActiveSyncPolling() throws IOException {
        return this.call(new UfsCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.stopActiveSyncPolling();
            }

            @Override
            public String methodName() {
                return "StopActiveSyncPolling";
            }
        });
    }

    @Override
    public SyncInfo getActiveSyncInfo() throws IOException {
        return this.call(new UfsCallable<SyncInfo>(){

            @Override
            public SyncInfo call() throws IOException {
                return UnderFileSystemWithLogging.this.mUnderFileSystem.getActiveSyncInfo();
            }

            @Override
            public String methodName() {
                return "GetActiveSyncInfo";
            }
        });
    }

    @Override
    public void startSync(final AlluxioURI uri) throws IOException {
        this.call(new UfsCallable<Void>(){

            @Override
            public Void call() throws IOException {
                UnderFileSystemWithLogging.this.mUnderFileSystem.startSync(uri);
                return null;
            }

            @Override
            public String methodName() {
                return "StartSync";
            }

            @Override
            public String toString() {
                return String.format("uri=%s", uri.toString());
            }
        });
    }

    @Override
    public void stopSync(final AlluxioURI uri) throws IOException {
        this.call(new UfsCallable<Void>(){

            @Override
            public Void call() throws IOException {
                UnderFileSystemWithLogging.this.mUnderFileSystem.stopSync(uri);
                return null;
            }

            @Override
            public String methodName() {
                return "StopSync";
            }

            @Override
            public String toString() {
                return String.format("uri=%s", uri.toString());
            }
        });
    }

    public UnderFileSystem getUnderFileSystem() {
        return this.mUnderFileSystem;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T call(UfsCallable<T> callable) throws IOException {
        String methodName = callable.methodName();
        long startMs = System.currentTimeMillis();
        LOG.debug("Enter: {}({})", (Object)methodName, callable);
        try (Timer.Context ctx = MetricsSystem.timer(this.getQualifiedMetricName(methodName)).time();){
            T ret = callable.call();
            long durationMs = System.currentTimeMillis() - startMs;
            LOG.debug("Exit (OK): {}({}) in {} ms", new Object[]{methodName, callable, durationMs});
            if (durationMs >= this.mLoggingThreshold) {
                LOG.warn("{}({}) returned OK in {} ms (>={} ms)", new Object[]{methodName, callable, durationMs, this.mLoggingThreshold});
            }
            T t = ret;
            return t;
        }
        catch (IOException e) {
            long durationMs = System.currentTimeMillis() - startMs;
            MetricsSystem.counter(this.getQualifiedFailureMetricName(methodName)).inc();
            LOG.debug("Exit (Error): {}({}) in {} ms, Error={}", new Object[]{methodName, callable, durationMs, e.toString()});
            if (durationMs < this.mLoggingThreshold) throw e;
            LOG.warn("{}({}) returned \"{}\" in {} ms (>={} ms)", new Object[]{methodName, callable, e, durationMs, this.mLoggingThreshold});
            throw e;
        }
    }

    @Override
    public boolean isSeekable() {
        return this.mUnderFileSystem.isSeekable();
    }

    private String getQualifiedMetricName(String metricName) {
        try {
            if (SecurityUtils.isAuthenticationEnabled(this.mConf) && AuthenticatedClientUser.get(this.mConf) != null) {
                return Metric.getMetricNameWithTags(metricName, "User", AuthenticatedClientUser.get(this.mConf).getName(), "UFS", this.mEscapedPath, "UFS_TYPE", this.mUnderFileSystem.getUnderFSType());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Metric.getMetricNameWithTags(metricName, "UFS", this.mEscapedPath, "UFS_TYPE", this.mUnderFileSystem.getUnderFSType());
    }

    private String getQualifiedFailureMetricName(String metricName) {
        return this.getQualifiedMetricName(metricName + "Failures");
    }

    public static abstract class UfsCallable<T> {
        abstract T call() throws IOException;

        abstract String methodName();

        public String toString() {
            return "";
        }
    }
}

