/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl.bin;

import alluxio.shaded.client.software.amazon.ionDecimal;
import alluxio.shaded.client.software.amazon.ionIonDatagram;
import alluxio.shaded.client.software.amazon.ionIonReader;
import alluxio.shaded.client.software.amazon.ionIonType;
import alluxio.shaded.client.software.amazon.ionIonValue;
import alluxio.shaded.client.software.amazon.ionSymbolToken;
import alluxio.shaded.client.software.amazon.ionTimestamp;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateByteTransferReader;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateByteTransferSink;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonWriter;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateSymtabExtendsCache;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateUtils;
import java.io.IOException;
import java.math.BigInteger;

abstract class AbstractIonWriter
implements PrivateIonWriter,
PrivateByteTransferSink {
    private final PrivateSymtabExtendsCache symtabExtendsCache;

    AbstractIonWriter(WriteValueOptimization optimization) {
        this.symtabExtendsCache = optimization == WriteValueOptimization.COPY_OPTIMIZED ? new PrivateSymtabExtendsCache() : null;
    }

    public final void writeValue(ionIonValue value) throws IOException {
        if (value != null) {
            if (value instanceof ionIonDatagram) {
                this.finish();
            }
            value.writeTo(this);
        }
    }

    public final void writeValue(ionIonReader reader) throws IOException {
        PrivateByteTransferReader transferReader;
        ionIonType type = reader.getType();
        if (this.isStreamCopyOptimized() && (transferReader = reader.asFacet(PrivateByteTransferReader.class)) != null && (PrivateUtils.isNonSymbolScalar(type) || this.symtabExtendsCache.symtabsCompat(this.getSymbolTable(), reader.getSymbolTable()))) {
            transferReader.transferCurrentValue(this);
            return;
        }
        this.writeValueRecursive(reader);
    }

    public final void writeValueRecursive(ionIonReader reader) throws IOException {
        ionSymbolToken[] annotations;
        ionIonType type = reader.getType();
        ionSymbolToken fieldName = reader.getFieldNameSymbol();
        if (fieldName != null && !this.isFieldNameSet() && this.isInStruct()) {
            this.setFieldNameSymbol(fieldName);
        }
        if ((annotations = reader.getTypeAnnotationSymbols()).length > 0) {
            this.setTypeAnnotationSymbols(annotations);
        }
        if (reader.isNullValue()) {
            this.writeNull(type);
            return;
        }
        block0 : switch (type) {
            case BOOL: {
                boolean booleanValue = reader.booleanValue();
                this.writeBool(booleanValue);
                break;
            }
            case INT: {
                switch (reader.getIntegerSize()) {
                    case INT: {
                        int intValue = reader.intValue();
                        this.writeInt(intValue);
                        break block0;
                    }
                    case LONG: {
                        long longValue = reader.longValue();
                        this.writeInt(longValue);
                        break block0;
                    }
                    case BIG_INTEGER: {
                        BigInteger bigIntegerValue = reader.bigIntegerValue();
                        this.writeInt(bigIntegerValue);
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case FLOAT: {
                double doubleValue = reader.doubleValue();
                this.writeFloat(doubleValue);
                break;
            }
            case DECIMAL: {
                ionDecimal decimalValue = reader.decimalValue();
                this.writeDecimal(decimalValue);
                break;
            }
            case TIMESTAMP: {
                ionTimestamp timestampValue = reader.timestampValue();
                this.writeTimestamp(timestampValue);
                break;
            }
            case SYMBOL: {
                ionSymbolToken symbolValue = reader.symbolValue();
                this.writeSymbolToken(symbolValue);
                break;
            }
            case STRING: {
                String stringValue = reader.stringValue();
                this.writeString(stringValue);
                break;
            }
            case CLOB: {
                byte[] clobValue = reader.newBytes();
                this.writeClob(clobValue);
                break;
            }
            case BLOB: {
                byte[] blobValue = reader.newBytes();
                this.writeBlob(blobValue);
                break;
            }
            case LIST: 
            case SEXP: 
            case STRUCT: {
                reader.stepIn();
                this.stepIn(type);
                while (reader.next() != null) {
                    this.writeValue(reader);
                }
                this.stepOut();
                reader.stepOut();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type: " + (Object)((Object)type));
            }
        }
    }

    public final void writeValues(ionIonReader reader) throws IOException {
        if (reader.getType() != null) {
            this.writeValue(reader);
        }
        while (reader.next() != null) {
            this.writeValue(reader);
        }
    }

    public final boolean isStreamCopyOptimized() {
        return this.symtabExtendsCache != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WriteValueOptimization {
        NONE,
        COPY_OPTIMIZED;

    }
}

