/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionapps;

import alluxio.shaded.client.software.amazon.ionIonCatalog;
import alluxio.shaded.client.software.amazon.ionIonException;
import alluxio.shaded.client.software.amazon.ionIonReader;
import alluxio.shaded.client.software.amazon.ionIonType;
import alluxio.shaded.client.software.amazon.ionIonWriter;
import alluxio.shaded.client.software.amazon.ionSymbolTable;
import alluxio.shaded.client.software.amazon.ionapps.BaseApp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class SymtabApp
extends BaseApp {
    private ArrayList<ionSymbolTable> myImports = new ArrayList();
    private ArrayList<String> mySymbols = new ArrayList();
    private String mySymtabName;
    private int mySymtabVersion;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Need one file to build symtab");
            return;
        }
        SymtabApp app = new SymtabApp();
        app.doMain(args);
    }

    protected int processOptions(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("--catalog".equals(arg)) {
                String symtabPath = args[++i];
                this.loadCatalog(symtabPath);
                continue;
            }
            if ("--import".equals(arg)) {
                String name = args[++i];
                ionIonCatalog catalog = this.mySystem.getCatalog();
                ionSymbolTable table = catalog.getTable(name);
                if (table == null) {
                    String message = "There's no symbol table in the catalog named " + name;
                    throw new RuntimeException(message);
                }
                this.myImports.add(table);
                this.logDebug("Imported symbol table " + name + "@" + table.getVersion());
                continue;
            }
            if ("--name".equals(arg)) {
                if (this.mySymtabName != null) {
                    throw new RuntimeException("Multiple names");
                }
                this.mySymtabName = args[++i];
                if (this.mySymtabName.length() != 0) continue;
                throw new RuntimeException("Name must not be empty");
            }
            if ("--version".equals(arg)) {
                if (this.mySymtabVersion != 0) {
                    throw new RuntimeException("Multiple versions");
                }
                int version = Integer.parseInt(arg);
                if (version < 1) {
                    throw new RuntimeException("Version must be at least 1");
                }
                if (version != 1) {
                    String message = "Symtab extension not implemented";
                    throw new UnsupportedOperationException(message);
                }
                this.mySymtabVersion = version;
                continue;
            }
            return i;
        }
        return args.length;
    }

    protected boolean optionsAreValid(String[] filePaths) {
        if (this.mySymtabName == null) {
            throw new RuntimeException("Must provide --name");
        }
        if (this.mySymtabVersion == 0) {
            this.mySymtabVersion = 1;
        }
        if (filePaths.length == 0) {
            System.err.println("Must provide list of files to provide symbols");
            return false;
        }
        return true;
    }

    public void processFiles(String[] filePaths) {
        super.processFiles(filePaths);
        ionSymbolTable[] importArray = new ionSymbolTable[this.myImports.size()];
        this.myImports.toArray(importArray);
        ionSymbolTable mySymtab = this.mySystem.newSharedSymbolTable(this.mySymtabName, this.mySymtabVersion, this.mySymbols.iterator(), importArray);
        ionIonWriter w = this.mySystem.newTextWriter(System.out);
        try {
            mySymtab.writeTo(w);
            System.out.println();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void process(ionIonReader reader) throws ionIonException {
        ionIonType type;
        while ((type = reader.next()) != null) {
            String fieldName = reader.getFieldName();
            this.intern(fieldName);
            this.internAnnotations(reader);
            switch (type) {
                case SYMBOL: {
                    String text = reader.stringValue();
                    this.intern(text);
                    break;
                }
                case LIST: 
                case SEXP: 
                case STRUCT: {
                    reader.stepIn();
                    break;
                }
            }
            while (reader.next() != null && reader.getDepth() > 0) {
                reader.stepOut();
            }
        }
    }

    private void internAnnotations(ionIonReader reader) {
        Iterator<String> i = reader.iterateTypeAnnotations();
        assert (i != null);
        while (i.hasNext()) {
            String ann = i.next();
            this.intern(ann);
        }
    }

    private void intern(String text) {
        if (text != null) {
            if (text.equals("$ion") || text.startsWith("$ion_")) {
                return;
            }
            this.mySymbols.add(text);
        }
    }
}

