/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.amazonaws.monitoring;

import alluxio.shaded.client.com.amazonaws.SdkClientException;
import alluxio.shaded.client.com.amazonaws.annotation.ThreadSafe;
import alluxio.shaded.client.com.amazonaws.monitoring.CsmConfiguration;
import alluxio.shaded.client.com.amazonaws.monitoring.CsmConfigurationProvider;

@ThreadSafe
public final class SystemPropertyCsmConfigurationProvider
implements CsmConfigurationProvider {
    @Override
    public CsmConfiguration getConfiguration() throws SdkClientException {
        String enabled = System.getProperty("alluxio.shaded.client.com.amazonaws.sdk.csm.enabled");
        if (enabled == null) {
            throw new SdkClientException("Unable to load Client Side Monitoring configurations from system properties variables!");
        }
        String host = System.getProperty("alluxio.shaded.client.com.amazonaws.sdk.csm.host", "127.0.0.1");
        String port = System.getProperty("alluxio.shaded.client.com.amazonaws.sdk.csm.port");
        String clientId = System.getProperty("alluxio.shaded.client.com.amazonaws.sdk.csm.clientId", "");
        try {
            int portNumber = port == null ? 31000 : Integer.parseInt(port);
            return CsmConfiguration.builder().withEnabled(Boolean.parseBoolean(enabled)).withHost(host).withPort(portNumber).withClientId(clientId).build();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to load Client Side Monitoring configurations from system properties variables!", e);
        }
    }
}

