/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.TieredIdentity;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Optional;

@ThreadSafe
public final class TieredIdentityUtils {
    public static boolean matches(TieredIdentity.LocalityTier tier, TieredIdentity.LocalityTier otherTier, boolean resolveIpAddress) {
        String otherTierName = otherTier.getTierName();
        if (!tier.getTierName().equals(otherTierName)) {
            return false;
        }
        String otherTierValue = otherTier.getValue();
        if (tier.getValue() != null && tier.getValue().equals(otherTierValue)) {
            return true;
        }
        if (resolveIpAddress && "node".equals(tier.getTierName())) {
            try {
                String tierIpAddress = NetworkAddressUtils.resolveIpAddress(tier.getValue());
                String otherTierIpAddress = NetworkAddressUtils.resolveIpAddress(otherTierValue);
                if (tierIpAddress != null && tierIpAddress.equals(otherTierIpAddress)) {
                    return true;
                }
            }
            catch (UnknownHostException e) {
                return false;
            }
        }
        return false;
    }

    public static Optional<TieredIdentity> nearest(TieredIdentity tieredIdentity, List<TieredIdentity> identities, AlluxioConfiguration conf) {
        if (identities.isEmpty()) {
            return Optional.empty();
        }
        for (TieredIdentity.LocalityTier tier : tieredIdentity.getTiers()) {
            if (tier == null) {
                return Optional.of(identities.get(0));
            }
            for (TieredIdentity identity : identities) {
                for (TieredIdentity.LocalityTier otherTier : identity.getTiers()) {
                    if (!TieredIdentityUtils.matches(tier, otherTier, conf.getBoolean(PropertyKey.LOCALITY_COMPARE_NODE_IP))) continue;
                    return Optional.of(identity);
                }
            }
        }
        return Optional.of(identities.get(0));
    }

    private TieredIdentityUtils() {
    }
}

