/*
 * Decompiled with CFR 0.152.
 */
package alluxio.retry;

import alluxio.retry.RetryPolicy;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.util.concurrent.TimeUnit;

@NotThreadSafe
public abstract class SleepingRetry
implements RetryPolicy {
    private final int mMaxRetries;
    private int mAttemptCount = 0;

    protected SleepingRetry(int maxRetries) {
        Preconditions.checkArgument(maxRetries >= 0, "Max retries must be a non-negative number");
        this.mMaxRetries = maxRetries;
    }

    @Override
    public int getAttemptCount() {
        return this.mAttemptCount;
    }

    @Override
    public boolean attempt() {
        if (this.mAttemptCount <= this.mMaxRetries) {
            if (this.mAttemptCount == 0) {
                ++this.mAttemptCount;
                return true;
            }
            try {
                this.getSleepUnit().sleep(this.getSleepTime());
                ++this.mAttemptCount;
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    protected TimeUnit getSleepUnit() {
        return TimeUnit.MILLISECONDS;
    }

    protected abstract long getSleepTime();
}

