/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.grpc.BlockWorkerGrpc;
import alluxio.grpc.Chunk;
import alluxio.grpc.DataMessage;
import alluxio.grpc.DataMessageMarshaller;
import alluxio.grpc.GrpcSerializationUtils;
import alluxio.grpc.ReadableDataBuffer;
import alluxio.grpc.WriteRequest;
import alluxio.grpc.WriteRequestCommand;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.NettyDataBuffer;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.protobuf.CodedOutputStream;
import alluxio.shaded.client.com.google.protobuf.UnsafeByteOperations;
import alluxio.shaded.client.io.grpc.internal.ReadableBuffer;
import alluxio.shaded.client.io.grpc.internal.ReadableBuffers;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.io.netty.buffer.Unpooled;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.proto.ProtoUtils;
import java.io.IOException;
import java.io.InputStream;

@NotThreadSafe
public class WriteRequestMarshaller
extends DataMessageMarshaller<WriteRequest> {
    private static final int CHUNK_TAG = GrpcSerializationUtils.makeTag(2, 2);

    public WriteRequestMarshaller() {
        super(BlockWorkerGrpc.getWriteBlockMethod().getRequestMarshaller());
    }

    @Override
    protected ByteBuf[] serialize(WriteRequest message) throws IOException {
        if (message.hasCommand()) {
            byte[] command = new byte[message.getSerializedSize()];
            CodedOutputStream stream = CodedOutputStream.newInstance(command);
            message.writeTo(stream);
            return new ByteBuf[]{Unpooled.wrappedBuffer(command)};
        }
        Object chunkBuffer = this.pollBuffer(message);
        if (chunkBuffer == null) {
            if (!message.hasChunk() || !message.getChunk().hasData()) {
                return new ByteBuf[0];
            }
            chunkBuffer = new NettyDataBuffer(Unpooled.wrappedBuffer(message.getChunk().getData().asReadOnlyByteBuffer()));
        }
        int headerSize = message.getSerializedSize() - chunkBuffer.readableBytes();
        byte[] header = new byte[headerSize];
        CodedOutputStream stream = CodedOutputStream.newInstance(header);
        stream.writeTag(2, 2);
        stream.writeUInt32NoTag(message.getChunk().getSerializedSize());
        stream.writeTag(1, 2);
        stream.writeUInt32NoTag(chunkBuffer.readableBytes());
        return new ByteBuf[]{Unpooled.wrappedBuffer(header), (ByteBuf)chunkBuffer.getNettyOutput()};
    }

    @Override
    protected WriteRequest deserialize(ReadableBuffer buffer) throws IOException {
        if (buffer.readableBytes() == 0) {
            return WriteRequest.getDefaultInstance();
        }
        try (InputStream is = ReadableBuffers.openStream(buffer, false);){
            int tag = ProtoUtils.readRawVarint32(is);
            int messageSize = ProtoUtils.readRawVarint32(is);
            if (tag != CHUNK_TAG) {
                WriteRequest writeRequest = WriteRequest.newBuilder().setCommand(WriteRequestCommand.parseFrom(is)).build();
                return writeRequest;
            }
            Preconditions.checkState(messageSize == buffer.readableBytes());
            Preconditions.checkState(ProtoUtils.readRawVarint32(is) == GrpcSerializationUtils.makeTag(1, 2));
            int chunkSize = ProtoUtils.readRawVarint32(is);
            Preconditions.checkState(chunkSize == buffer.readableBytes());
            WriteRequest request = WriteRequest.newBuilder().build();
            ByteBuf bytebuf = GrpcSerializationUtils.getByteBufFromReadableBuffer(buffer);
            if (bytebuf != null) {
                this.offerBuffer(new NettyDataBuffer(bytebuf), request);
            } else {
                this.offerBuffer(new ReadableDataBuffer(buffer), request);
            }
            WriteRequest writeRequest = request;
            return writeRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteRequest combineData(@Nullable DataMessage<WriteRequest, DataBuffer> message) {
        if (message == null) {
            return null;
        }
        DataBuffer buffer = message.getBuffer();
        if (buffer == null) {
            return message.getMessage();
        }
        try {
            byte[] bytes = new byte[buffer.readableBytes()];
            buffer.readBytes(bytes, 0, bytes.length);
            WriteRequest writeRequest = message.getMessage().toBuilder().setChunk(Chunk.newBuilder().setData(UnsafeByteOperations.unsafeWrap(bytes)).build()).build();
            return writeRequest;
        }
        finally {
            message.getBuffer().release();
        }
    }
}

