/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.Lists;
import alluxio.shaded.client.com.google.common.hash.HashFunction;
import alluxio.shaded.client.com.google.common.hash.Hashing;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.wire.WorkerNetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;

@NotThreadSafe
public final class DeterministicHashPolicy
implements BlockLocationPolicy {
    private final int mShards;
    private final Random mRandom = new Random();
    private final HashFunction mHashFunc = Hashing.md5();

    public DeterministicHashPolicy(AlluxioConfiguration conf) {
        int numShards = conf.getInt(PropertyKey.USER_UFS_BLOCK_READ_LOCATION_POLICY_DETERMINISTIC_HASH_SHARDS);
        Preconditions.checkArgument(numShards >= 1);
        this.mShards = numShards;
    }

    @Override
    public Optional<WorkerNetAddress> getWorker(GetWorkerOptions options) {
        ArrayList<BlockWorkerInfo> workerInfos = Lists.newArrayList(options.getBlockWorkerInfos());
        workerInfos.sort((o1, o2) -> o1.getNetAddress().toString().compareToIgnoreCase(o2.getNetAddress().toString()));
        HashMap<WorkerNetAddress, BlockWorkerInfo> blockWorkerInfoMap = new HashMap<WorkerNetAddress, BlockWorkerInfo>();
        for (BlockWorkerInfo workerInfo : options.getBlockWorkerInfos()) {
            blockWorkerInfoMap.put(workerInfo.getNetAddress(), workerInfo);
        }
        ArrayList<WorkerNetAddress> workers = new ArrayList<WorkerNetAddress>();
        int hv = Math.abs(this.mHashFunc.newHasher().putLong(options.getBlockInfo().getBlockId()).hash().asInt());
        int index = hv % workerInfos.size();
        for (BlockWorkerInfo ignored : workerInfos) {
            WorkerNetAddress candidate = ((BlockWorkerInfo)workerInfos.get(index)).getNetAddress();
            BlockWorkerInfo workerInfo = (BlockWorkerInfo)blockWorkerInfoMap.get(candidate);
            if (workerInfo != null && workerInfo.getCapacityBytes() >= options.getBlockInfo().getLength()) {
                workers.add(candidate);
                if (workers.size() >= this.mShards) break;
            }
            index = (index + 1) % workerInfos.size();
        }
        return workers.isEmpty() ? Optional.empty() : Optional.of(workers.get(this.mRandom.nextInt(workers.size())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeterministicHashPolicy)) {
            return false;
        }
        DeterministicHashPolicy that = (DeterministicHashPolicy)o;
        return Objects.equal(this.mShards, that.mShards);
    }

    public int hashCode() {
        return Objects.hashCode(this.mShards);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("shards", this.mShards).toString();
    }
}

