/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.GrpcChannel;
import alluxio.grpc.GrpcChannelPool;
import alluxio.grpc.GrpcNetworkGroup;
import alluxio.grpc.GrpcServerAddress;
import alluxio.security.authentication.AuthType;
import javax.security.auth.Subject;

public final class GrpcChannelBuilder {
    private final GrpcServerAddress mAddress;
    private final AlluxioConfiguration mConfiguration;
    private Subject mParentSubject;
    private AuthType mAuthType;
    private GrpcNetworkGroup mNetworkGroup = GrpcNetworkGroup.RPC;

    private GrpcChannelBuilder(GrpcServerAddress address, AlluxioConfiguration conf) {
        this.mAddress = address;
        this.mConfiguration = conf;
        this.mAuthType = conf.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
    }

    public static GrpcChannelBuilder newBuilder(GrpcServerAddress address, AlluxioConfiguration conf) {
        return new GrpcChannelBuilder(address, conf);
    }

    public GrpcChannelBuilder setSubject(Subject subject) {
        this.mParentSubject = subject;
        return this;
    }

    public GrpcChannelBuilder disableAuthentication() {
        this.mAuthType = AuthType.NOSASL;
        return this;
    }

    public GrpcChannelBuilder setNetworkGroup(GrpcNetworkGroup group) {
        this.mNetworkGroup = group;
        return this;
    }

    public GrpcChannel build() throws AlluxioStatusException {
        GrpcChannel channel = GrpcChannelPool.INSTANCE.acquireChannel(this.mNetworkGroup, this.mAddress, this.mConfiguration);
        try {
            channel.authenticate(this.mAuthType, this.mParentSubject, this.mConfiguration);
        }
        catch (Throwable t) {
            try {
                channel.close();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to release the connection: %s", channel.getChannelKey()), e);
            }
            if (t instanceof AlluxioStatusException) {
                throw t;
            }
            throw AlluxioStatusException.fromThrowable(t);
        }
        return channel;
    }
}

