/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.file.BaseFileSystem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystemCache;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.ListStatusPartialResult;
import alluxio.client.file.MetadataCachingFileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.LocalCacheFileSystem;
import alluxio.client.file.options.FileSystemOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.exception.AlluxioException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.FileIncompleteException;
import alluxio.exception.InvalidPathException;
import alluxio.exception.OpenDirectoryException;
import alluxio.grpc.CheckAccessPOptions;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.ListStatusPartialPOptions;
import alluxio.grpc.LoadMetadataPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.MountPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.RenamePOptions;
import alluxio.grpc.ScheduleAsyncPersistencePOptions;
import alluxio.grpc.SetAclAction;
import alluxio.grpc.SetAclPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.UnmountPOptions;
import alluxio.security.authorization.AclEntry;
import alluxio.security.user.UserState;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.util.CommonUtils;
import alluxio.wire.BlockLocationInfo;
import alluxio.wire.MountPointInfo;
import alluxio.wire.SyncPointInfo;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FileSystem
extends Closeable {
    public boolean isClosed();

    public void checkAccess(AlluxioURI var1, CheckAccessPOptions var2) throws InvalidPathException, IOException, AlluxioException;

    default public void createDirectory(AlluxioURI path) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        this.createDirectory(path, CreateDirectoryPOptions.getDefaultInstance());
    }

    public void createDirectory(AlluxioURI var1, CreateDirectoryPOptions var2) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException;

    default public FileOutStream createFile(AlluxioURI path) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        return this.createFile(path, CreateFilePOptions.getDefaultInstance());
    }

    public FileOutStream createFile(AlluxioURI var1, CreateFilePOptions var2) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException;

    default public void delete(AlluxioURI path) throws DirectoryNotEmptyException, FileDoesNotExistException, IOException, AlluxioException {
        this.delete(path, DeletePOptions.getDefaultInstance());
    }

    public void delete(AlluxioURI var1, DeletePOptions var2) throws DirectoryNotEmptyException, FileDoesNotExistException, IOException, AlluxioException;

    default public boolean exists(AlluxioURI path) throws InvalidPathException, IOException, AlluxioException {
        return this.exists(path, ExistsPOptions.getDefaultInstance());
    }

    public boolean exists(AlluxioURI var1, ExistsPOptions var2) throws InvalidPathException, IOException, AlluxioException;

    default public void free(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        this.free(path, FreePOptions.getDefaultInstance());
    }

    public void free(AlluxioURI var1, FreePOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    default public List<BlockLocationInfo> getBlockLocations(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        return this.getBlockLocations(this.getStatus(path));
    }

    public List<BlockLocationInfo> getBlockLocations(URIStatus var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public AlluxioConfiguration getConf();

    default public URIStatus getStatus(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        return this.getStatus(path, GetStatusPOptions.getDefaultInstance());
    }

    public URIStatus getStatus(AlluxioURI var1, GetStatusPOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    default public void iterateStatus(AlluxioURI path, Consumer<? super URIStatus> action) throws FileDoesNotExistException, IOException, AlluxioException {
        this.iterateStatus(path, ListStatusPOptions.getDefaultInstance(), action);
    }

    public void iterateStatus(AlluxioURI var1, ListStatusPOptions var2, Consumer<? super URIStatus> var3) throws FileDoesNotExistException, IOException, AlluxioException;

    default public List<URIStatus> listStatus(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        return this.listStatus(path, ListStatusPOptions.getDefaultInstance());
    }

    public List<URIStatus> listStatus(AlluxioURI var1, ListStatusPOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    public ListStatusPartialResult listStatusPartial(AlluxioURI var1, ListStatusPartialPOptions var2) throws AlluxioException, IOException;

    default public void loadMetadata(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        ListStatusPOptions options = ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ALWAYS).setRecursive(LoadMetadataPOptions.getDefaultInstance().getRecursive()).setLoadMetadataOnly(true).build();
        this.loadMetadata(path, options);
    }

    public void loadMetadata(AlluxioURI var1, ListStatusPOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    default public void mount(AlluxioURI alluxioPath, AlluxioURI ufsPath) throws IOException, AlluxioException {
        this.mount(alluxioPath, ufsPath, MountPOptions.getDefaultInstance());
    }

    public void mount(AlluxioURI var1, AlluxioURI var2, MountPOptions var3) throws IOException, AlluxioException;

    public void updateMount(AlluxioURI var1, MountPOptions var2) throws IOException, AlluxioException;

    default public Map<String, MountPointInfo> getMountTable() throws IOException, AlluxioException {
        return this.getMountTable(true);
    }

    public Map<String, MountPointInfo> getMountTable(boolean var1) throws IOException, AlluxioException;

    public List<SyncPointInfo> getSyncPathList() throws IOException, AlluxioException;

    default public FileInStream openFile(AlluxioURI path) throws FileDoesNotExistException, OpenDirectoryException, FileIncompleteException, IOException, AlluxioException {
        return this.openFile(path, OpenFilePOptions.getDefaultInstance());
    }

    public FileInStream openFile(AlluxioURI var1, OpenFilePOptions var2) throws FileDoesNotExistException, OpenDirectoryException, FileIncompleteException, IOException, AlluxioException;

    public FileInStream openFile(URIStatus var1, OpenFilePOptions var2) throws FileDoesNotExistException, OpenDirectoryException, FileIncompleteException, IOException, AlluxioException;

    default public void persist(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        this.persist(path, ScheduleAsyncPersistencePOptions.getDefaultInstance());
    }

    public void persist(AlluxioURI var1, ScheduleAsyncPersistencePOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    default public void rename(AlluxioURI src, AlluxioURI dst) throws FileDoesNotExistException, IOException, AlluxioException {
        this.rename(src, dst, RenamePOptions.getDefaultInstance());
    }

    public void rename(AlluxioURI var1, AlluxioURI var2, RenamePOptions var3) throws FileDoesNotExistException, IOException, AlluxioException;

    public AlluxioURI reverseResolve(AlluxioURI var1) throws IOException, AlluxioException;

    default public void setAcl(AlluxioURI path, SetAclAction action, List<AclEntry> entries) throws FileDoesNotExistException, IOException, AlluxioException {
        this.setAcl(path, action, entries, SetAclPOptions.getDefaultInstance());
    }

    public void setAcl(AlluxioURI var1, SetAclAction var2, List<AclEntry> var3, SetAclPOptions var4) throws FileDoesNotExistException, IOException, AlluxioException;

    public void startSync(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    public void stopSync(AlluxioURI var1) throws FileDoesNotExistException, IOException, AlluxioException;

    default public void setAttribute(AlluxioURI path) throws FileDoesNotExistException, IOException, AlluxioException {
        this.setAttribute(path, SetAttributePOptions.getDefaultInstance());
    }

    public void setAttribute(AlluxioURI var1, SetAttributePOptions var2) throws FileDoesNotExistException, IOException, AlluxioException;

    default public void unmount(AlluxioURI path) throws IOException, AlluxioException {
        this.unmount(path, UnmountPOptions.getDefaultInstance());
    }

    public void unmount(AlluxioURI var1, UnmountPOptions var2) throws IOException, AlluxioException;

    public void needsSync(AlluxioURI var1) throws IOException, AlluxioException;

    public static class Factory {
        private static final Logger LOG = LoggerFactory.getLogger(Factory.class);
        private static final AtomicBoolean CONF_LOGGED = new AtomicBoolean(false);
        protected static final FileSystemCache FILESYSTEM_CACHE = new FileSystemCache();

        private Factory() {
        }

        public static FileSystem get() {
            return Factory.get(new Subject());
        }

        public static FileSystem get(Subject subject) {
            return Factory.get(subject, Configuration.global());
        }

        public static FileSystem get(Subject subject, AlluxioConfiguration conf) {
            Preconditions.checkNotNull(subject, "subject");
            FileSystemCache.Key key = new FileSystemCache.Key(UserState.Factory.create(conf, subject).getSubject(), conf);
            return FILESYSTEM_CACHE.get(key);
        }

        public static FileSystem create() {
            return Factory.create(FileSystemContext.create());
        }

        public static FileSystem create(AlluxioConfiguration alluxioConf) {
            return Factory.create(FileSystemContext.create(alluxioConf));
        }

        public static FileSystem create(ClientContext ctx) {
            return Factory.create(FileSystemContext.create(ctx));
        }

        public static FileSystem create(FileSystemContext context) {
            return Factory.create(context, FileSystemOptions.create(context.getClusterConf()));
        }

        public static FileSystem create(FileSystemContext context, FileSystemOptions options) {
            AlluxioConfiguration conf = context.getClusterConf();
            Factory.checkSortConf(conf);
            FileSystem fs = new BaseFileSystem(context);
            if (options.isMetadataCacheEnabled()) {
                fs = new MetadataCachingFileSystem(fs, context);
            }
            if (options.isDataCacheEnabled() && CommonUtils.PROCESS_TYPE.get() == CommonUtils.ProcessType.CLIENT) {
                try {
                    CacheManager cacheManager = CacheManager.Factory.get(conf);
                    return new LocalCacheFileSystem(cacheManager, fs, conf);
                }
                catch (IOException e) {
                    LOG.error("Fallback without client caching: ", (Throwable)e);
                }
            }
            return fs;
        }

        static void checkSortConf(AlluxioConfiguration conf) {
            if (LOG.isDebugEnabled() && !CONF_LOGGED.getAndSet(true)) {
                ArrayList<PropertyKey> keys = new ArrayList<PropertyKey>(conf.keySet());
                keys.sort(Comparator.comparing(PropertyKey::getName));
                for (PropertyKey key : keys) {
                    Object value = conf.getOrDefault(key, null);
                    Source source = conf.getSource(key);
                    LOG.debug("{}={} ({})", new Object[]{key.getName(), value, source});
                }
            }
        }
    }
}

