/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.com.google.common.cache.Cache;
import alluxio.shaded.client.com.google.common.cache.CacheBuilder;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.WorkerNetAddress;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

@ThreadSafe
public class CapacityBaseRandomPolicy
implements BlockLocationPolicy {
    private final Cache<Long, List<WorkerNetAddress>> mBlockLocationCache;
    private final int mMaxReplicaSize;

    public CapacityBaseRandomPolicy(AlluxioConfiguration conf) {
        Duration expirationTime = conf.getDuration(PropertyKey.USER_UFS_BLOCK_READ_LOCATION_POLICY_CACHE_EXPIRATION_TIME);
        int cacheSize = conf.getInt(PropertyKey.USER_UFS_BLOCK_READ_LOCATION_POLICY_CACHE_SIZE);
        this.mBlockLocationCache = CacheBuilder.newBuilder().maximumSize(cacheSize).expireAfterWrite(expirationTime).build();
        this.mMaxReplicaSize = conf.getInt(PropertyKey.USER_FILE_REPLICATION_MAX);
    }

    @Override
    public Optional<WorkerNetAddress> getWorker(GetWorkerOptions options) {
        WorkerNetAddress cacheAddress = this.findCacheWorker(options);
        if (cacheAddress != null) {
            return Optional.of(cacheAddress);
        }
        Iterable<BlockWorkerInfo> blockWorkerInfos = options.getBlockWorkerInfos();
        TreeMap rangeStartMap = new TreeMap();
        AtomicLong totalCapacity = new AtomicLong(0L);
        blockWorkerInfos.forEach(workerInfo -> {
            if (workerInfo.getCapacityBytes() > 0L) {
                long capacityRangeStart = totalCapacity.getAndAdd(workerInfo.getCapacityBytes());
                rangeStartMap.put(capacityRangeStart, workerInfo);
            }
        });
        if (totalCapacity.get() == 0L) {
            return Optional.empty();
        }
        long randomLong = this.randomInCapacity(totalCapacity.get());
        WorkerNetAddress targetWorker = ((BlockWorkerInfo)rangeStartMap.floorEntry(randomLong).getValue()).getNetAddress();
        this.addWorkerToCache(options.getBlockInfo().getBlockId(), targetWorker);
        return Optional.of(targetWorker);
    }

    protected long randomInCapacity(long totalCapacity) {
        return ThreadLocalRandom.current().nextLong(totalCapacity);
    }

    protected WorkerNetAddress findCacheWorker(GetWorkerOptions options) {
        List<WorkerNetAddress> cacheCandidateList = this.mBlockLocationCache.getIfPresent(options.getBlockInfo().getBlockId());
        if (cacheCandidateList != null && this.mMaxReplicaSize > 0) {
            HashSet<WorkerNetAddress> eligibleAddresses = new HashSet<WorkerNetAddress>();
            for (BlockWorkerInfo info : options.getBlockWorkerInfos()) {
                eligibleAddresses.add(info.getNetAddress());
            }
            List eligibleCacheList = cacheCandidateList.stream().filter(eligibleAddresses::contains).collect(Collectors.toList());
            if (eligibleCacheList.size() >= this.mMaxReplicaSize) {
                int index = ThreadLocalRandom.current().nextInt(eligibleCacheList.size());
                return (WorkerNetAddress)eligibleCacheList.get(index);
            }
        }
        return null;
    }

    protected void addWorkerToCache(Long blockId, WorkerNetAddress targetWorker) {
        if (this.mMaxReplicaSize <= 0) {
            return;
        }
        List<WorkerNetAddress> cacheWorkers = this.mBlockLocationCache.getIfPresent(blockId);
        if (cacheWorkers == null) {
            cacheWorkers = new CopyOnWriteArrayList<WorkerNetAddress>();
            this.mBlockLocationCache.put(blockId, cacheWorkers);
        }
        cacheWorkers.add(targetWorker);
    }
}

