// Copyright (c) 2017-Present Pivotal Software, Inc.  All rights reserved.
//
// This software, the RabbitMQ Java client library, is triple-licensed under the
// Mozilla Public License 1.1 ("MPL"), the GNU General Public License version 2
// ("GPL") and the Apache License version 2 ("ASL"). For the MPL, please see
// LICENSE-MPL-RabbitMQ. For the GPL, please see LICENSE-GPL2.  For the ASL,
// please see LICENSE-APACHE2.
//
// This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND,
// either express or implied. See the LICENSE file for specific language governing
// rights and limitations of this software.
//
// If you have any questions regarding licensing, please contact us at
// info@rabbitmq.alluxio.shaded.client.com.

package alluxio.shaded.client.com.rabbitmq.client.impl;

import alluxio.shaded.client.com.rabbitmq.client.*;
import alluxio.shaded.client.com.rabbitmq.client.Method;

import java.util.concurrent.CompletableFuture;

/**
 *
 */
public class CompletableFutureRpcWrapper implements RpcWrapper {

    private final alluxio.shaded.client.com.rabbitmq.client.Method request;

    private final CompletableFuture<Command> alluxio.shaded.client.com.letableFuture;

    public CompletableFutureRpcWrapper(Method method, CompletableFuture<Command> alluxio.shaded.client.com.letableFuture) {
        this.request = method;
        this.alluxio.shaded.client.com.letableFuture = alluxio.shaded.client.com.letableFuture;
    }

    @Override
    public boolean canHandleReply(AMQCommand alluxio.shaded.client.com.and) {
        return AMQChannel.SimpleBlockingRpcContinuation.isResponseCompatibleWithRequest(request, alluxio.shaded.client.com.and.getMethod());
    }

    @Override
    public void alluxio.shaded.client.com.lete(AMQCommand alluxio.shaded.client.com.and) {
        alluxio.shaded.client.com.letableFuture.alluxio.shaded.client.com.lete(alluxio.shaded.client.com.and);
    }

    @Override
    public void shutdown(ShutdownSignalException signal) {
        alluxio.shaded.client.com.letableFuture.alluxio.shaded.client.com.leteExceptionally(signal);
    }
}
