/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.apache.zookeeper.cli;

import alluxio.shaded.client.org.apache.commons.cli.CommandLine;
import alluxio.shaded.client.org.apache.commons.cli.Option;
import alluxio.shaded.client.org.apache.commons.cli.Options;
import alluxio.shaded.client.org.apache.commons.cli.ParseException;
import alluxio.shaded.client.org.apache.commons.cli.PosixParser;
import alluxio.shaded.client.org.apache.zookeeper.CreateMode;
import alluxio.shaded.client.org.apache.zookeeper.KeeperException;
import alluxio.shaded.client.org.apache.zookeeper.ZooDefs;
import alluxio.shaded.client.org.apache.zookeeper.cli.AclParser;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliCommand;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliException;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliParseException;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliWrapperException;
import alluxio.shaded.client.org.apache.zookeeper.cli.MalformedCommandException;
import alluxio.shaded.client.org.apache.zookeeper.cli.MalformedPathException;
import alluxio.shaded.client.org.apache.zookeeper.data.ACL;
import alluxio.shaded.client.org.apache.zookeeper.data.Stat;
import alluxio.shaded.client.org.apache.zookeeper.server.EphemeralType;
import java.util.List;

public class CreateCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public CreateCommand() {
        super("create", "[-s] [-e] [-c] [-t ttl] path [data] [acl]");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser = new PosixParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        CreateMode flags;
        long ttl;
        boolean hasE = this.cl.hasOption("e");
        boolean hasS = this.cl.hasOption("s");
        boolean hasC = this.cl.hasOption("c");
        boolean hasT = this.cl.hasOption("t");
        if (hasC && (hasE || hasS)) {
            throw new MalformedCommandException("-c cannot be combined with -s or -e. Containers cannot be ephemeral or sequential.");
        }
        try {
            ttl = hasT ? Long.parseLong(this.cl.getOptionValue("t")) : 0L;
        }
        catch (NumberFormatException e) {
            throw new MalformedCommandException("-t argument must be a long value");
        }
        if (hasT && hasE) {
            throw new MalformedCommandException("TTLs cannot be used with Ephemeral znodes");
        }
        if (hasT && hasC) {
            throw new MalformedCommandException("TTLs cannot be used with Container znodes");
        }
        if (hasE && hasS) {
            flags = CreateMode.EPHEMERAL_SEQUENTIAL;
        } else if (hasE) {
            flags = CreateMode.EPHEMERAL;
        } else if (hasS) {
            flags = hasT ? CreateMode.PERSISTENT_SEQUENTIAL_WITH_TTL : CreateMode.PERSISTENT_SEQUENTIAL;
        } else if (hasC) {
            flags = CreateMode.CONTAINER;
        } else {
            CreateMode createMode = flags = hasT ? CreateMode.PERSISTENT_WITH_TTL : CreateMode.PERSISTENT;
        }
        if (hasT) {
            try {
                EphemeralType.TTL.toEphemeralOwner(ttl);
            }
            catch (IllegalArgumentException e) {
                throw new MalformedCommandException(e.getMessage());
            }
        }
        String path = this.args[1];
        byte[] data = null;
        if (this.args.length > 2) {
            data = this.args[2].getBytes();
        }
        List<ACL> acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        if (this.args.length > 3) {
            acl = AclParser.parse(this.args[3]);
        }
        try {
            String newPath = hasT ? this.zk.create(path, data, acl, flags, new Stat(), ttl) : this.zk.create(path, data, acl, flags);
            this.err.println("Created " + newPath);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException.EphemeralOnLocalSessionException e) {
            this.err.println("Unable to create ephemeral node on a local session");
            throw new CliWrapperException(e);
        }
        catch (KeeperException.InvalidACLException ex) {
            this.err.println(ex.getMessage());
            throw new CliWrapperException(ex);
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return true;
    }

    static {
        options.addOption(new Option("e", false, "ephemeral"));
        options.addOption(new Option("s", false, "sequential"));
        options.addOption(new Option("c", false, "container"));
        options.addOption(new Option("t", true, "ttl"));
    }
}

