/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.quota;

import alluxio.client.quota.CacheScope;
import alluxio.shaded.client.com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class CacheQuota {
    public static final CacheQuota UNLIMITED = new CacheQuota(){

        @Override
        public long getQuota(CacheScope cacheScope) {
            return Long.MAX_VALUE;
        }
    };
    private final Map<CacheScope.Level, Long> mQuota;

    public CacheQuota(Map<CacheScope.Level, Long> quota) {
        this.mQuota = quota;
    }

    public CacheQuota() {
        this(ImmutableMap.of());
    }

    public long getQuota(CacheScope cacheScope) {
        return this.mQuota.getOrDefault((Object)cacheScope.level(), Long.MAX_VALUE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheQuota that = (CacheQuota)o;
        return Objects.equals(this.mQuota, that.mQuota);
    }

    public int hashCode() {
        return Objects.hash(this.mQuota);
    }
}

