/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.evictor;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.evictor.LRUCacheEvictor;
import alluxio.client.file.cache.evictor.NondeterministicLRUCacheEvictor;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.CommonUtils;

@ThreadSafe
public interface CacheEvictor {
    public static CacheEvictor create(AlluxioConfiguration conf) {
        boolean isNondeterministic = conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_EVICTOR_NONDETERMINISTIC_ENABLED);
        boolean isLRU = conf.getClass(PropertyKey.USER_CLIENT_CACHE_EVICTOR_CLASS).equals(LRUCacheEvictor.class);
        if (isNondeterministic && isLRU) {
            return new NondeterministicLRUCacheEvictor(conf);
        }
        return (CacheEvictor)CommonUtils.createNewClassInstance(conf.getClass(PropertyKey.USER_CLIENT_CACHE_EVICTOR_CLASS), new Class[]{AlluxioConfiguration.class}, new Object[]{conf});
    }

    public void updateOnGet(PageId var1);

    public void updateOnPut(PageId var1);

    public void updateOnDelete(PageId var1);

    @Nullable
    public PageId evict();

    public void reset();
}

