/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.cuckoofilter;

import alluxio.client.file.cache.cuckoofilter.CuckooStatus;
import alluxio.client.file.cache.cuckoofilter.CuckooTable;
import alluxio.client.file.cache.cuckoofilter.TagPosition;
import alluxio.collections.BitSet;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import java.util.concurrent.ThreadLocalRandom;

public class SimpleCuckooTable
implements CuckooTable {
    private final int mTagsPerBucket;
    private final int mBitsPerTag;
    private final BitSet mBits;
    private final int mNumBuckets;

    public SimpleCuckooTable(BitSet bitSet, int numBuckets, int tagsPerBucket, int bitsPerTag) {
        Preconditions.checkArgument(bitSet.size() == numBuckets * tagsPerBucket * bitsPerTag);
        this.mBits = bitSet;
        this.mNumBuckets = numBuckets;
        this.mTagsPerBucket = tagsPerBucket;
        this.mBitsPerTag = bitsPerTag;
    }

    @Override
    public int readTag(int bucketIndex, int slotIndex) {
        int tagStartIdx = this.getTagOffset(bucketIndex, slotIndex);
        int tag = 0;
        for (int k = 0; k < this.mBitsPerTag; ++k) {
            if (!this.mBits.get(tagStartIdx + k)) continue;
            tag |= 1 << k;
        }
        return tag;
    }

    @Override
    public void writeTag(int bucketIndex, int slotIndex, int tag) {
        int tagStartIdx = this.getTagOffset(bucketIndex, slotIndex);
        for (int k = 0; k < this.mBitsPerTag; ++k) {
            if (((long)tag & 1L << k) != 0L) {
                this.mBits.set(tagStartIdx + k);
                continue;
            }
            this.mBits.clear(tagStartIdx + k);
        }
    }

    @Override
    public TagPosition findTag(int bucketIndex, int tag) {
        for (int slotIndex = 0; slotIndex < this.mTagsPerBucket; ++slotIndex) {
            if (this.readTag(bucketIndex, slotIndex) != tag) continue;
            return new TagPosition(bucketIndex, slotIndex, CuckooStatus.OK);
        }
        return new TagPosition(-1, -1, CuckooStatus.FAILURE_KEY_NOT_FOUND);
    }

    @Override
    public TagPosition findTag(int bucketIndex1, int bucketIndex2, int tag) {
        for (int slotIndex = 0; slotIndex < this.mTagsPerBucket; ++slotIndex) {
            if (this.readTag(bucketIndex1, slotIndex) == tag) {
                return new TagPosition(bucketIndex1, slotIndex, CuckooStatus.OK);
            }
            if (this.readTag(bucketIndex2, slotIndex) != tag) continue;
            return new TagPosition(bucketIndex2, slotIndex, CuckooStatus.OK);
        }
        return new TagPosition(-1, -1, CuckooStatus.FAILURE_KEY_NOT_FOUND);
    }

    @Override
    public TagPosition deleteTag(int bucketIndex, int tag) {
        for (int slotIndex = 0; slotIndex < this.mTagsPerBucket; ++slotIndex) {
            if (this.readTag(bucketIndex, slotIndex) != tag) continue;
            this.writeTag(bucketIndex, slotIndex, 0);
            return new TagPosition(bucketIndex, slotIndex, CuckooStatus.OK);
        }
        return new TagPosition(-1, -1, CuckooStatus.FAILURE_KEY_NOT_FOUND);
    }

    @Override
    public int insertOrKickTag(int bucketIndex, int tag) {
        for (int slotIndex = 0; slotIndex < this.mTagsPerBucket; ++slotIndex) {
            if (this.readTag(bucketIndex, slotIndex) != 0) continue;
            this.writeTag(bucketIndex, slotIndex, tag);
            return 0;
        }
        int r = ThreadLocalRandom.current().nextInt(this.mTagsPerBucket);
        int oldTag = this.readTag(bucketIndex, r);
        this.writeTag(bucketIndex, r, tag);
        return oldTag;
    }

    @Override
    public int getNumTagsPerBuckets() {
        return this.mTagsPerBucket;
    }

    @Override
    public int getNumBuckets() {
        return this.mNumBuckets;
    }

    @Override
    public int getBitsPerTag() {
        return this.mBitsPerTag;
    }

    @Override
    public int getSizeInBytes() {
        return this.mBits.size() >> 3;
    }

    @Override
    public int getSizeInTags() {
        return this.mNumBuckets * this.mTagsPerBucket;
    }

    private int getTagOffset(int bucketIndex, int posInBucket) {
        return bucketIndex * this.mTagsPerBucket * this.mBitsPerTag + posInBucket * this.mBitsPerTag;
    }
}

