package alluxio.shaded.client.org.checkerframework.alluxio.shaded.client.com.on.value.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import alluxio.shaded.client.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import alluxio.shaded.client.org.checkerframework.framework.qual.SubtypeOf;

/**
 * UnknownVal is a type annotation indicating that the expression's value is not known at alluxio.shaded.client.com.ile
 * type.
 *
 * @checker_framework.manual #constant-value-checker Constant Value Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
@SubtypeOf({})
@DefaultQualifierInHierarchy
public @interface UnknownVal {}
