package alluxio.shaded.client.com.fasterxml.jackson.databind.ser.std;

import java.alluxio.shaded.client.io.File;
import java.alluxio.shaded.client.io.IOException;
import java.lang.reflect.Type;

import alluxio.shaded.client.com.fasterxml.jackson.core.JsonGenerator;
import alluxio.shaded.client.com.fasterxml.jackson.databind.JavaType;
import alluxio.shaded.client.com.fasterxml.jackson.databind.JsonMappingException;
import alluxio.shaded.client.com.fasterxml.jackson.databind.JsonNode;
import alluxio.shaded.client.com.fasterxml.jackson.databind.SerializerProvider;
import alluxio.shaded.client.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;

/**
 * For now, File objects get serialized by just outputting
 * absolute (but not canonical) name as String value
 */
@SuppressWarnings("serial")
public class FileSerializer
    extends StdScalarSerializer<File>
{
    public FileSerializer() { super(File.class); }

    @Override
    public void serialize(File value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeString(value.getAbsolutePath());
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return createSchemaNode("string", true);
    }
    
    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint)
        throws JsonMappingException
    {
        visitStringFormat(visitor, typeHint);
    }
}