/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.apache.zookeeper.cli;

import alluxio.shaded.client.org.apache.commons.cli.CommandLine;
import alluxio.shaded.client.org.apache.commons.cli.Options;
import alluxio.shaded.client.org.apache.commons.cli.ParseException;
import alluxio.shaded.client.org.apache.commons.cli.PosixParser;
import alluxio.shaded.client.org.apache.zookeeper.KeeperException;
import alluxio.shaded.client.org.apache.zookeeper.ZKUtil;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliCommand;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliException;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliParseException;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliWrapperException;
import alluxio.shaded.client.org.apache.zookeeper.cli.MalformedPathException;

public class DeleteAllCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public DeleteAllCommand() {
        this("deleteall");
    }

    public DeleteAllCommand(String cmdStr) {
        super(cmdStr, "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        PosixParser parser = new PosixParser();
        try {
            cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        this.printDeprecatedWarning();
        String path = this.args[1];
        try {
            ZKUtil.deleteRecursive(this.zk, path);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }

    private void printDeprecatedWarning() {
        if ("rmr".equals(this.args[0])) {
            this.err.println("The command 'rmr' has been deprecated. Please use 'deleteall' instead.");
        }
    }
}

