/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security;

import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.security.Principal;

@ThreadSafe
public final class CurrentUser
implements Principal {
    private final String mName;
    private final String mServiceName;

    public CurrentUser(String name) {
        this(name, "");
    }

    public CurrentUser(String name, String serviceName) {
        this.mName = name;
        this.mServiceName = serviceName;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String toString() {
        return this.mName;
    }

    public String getServiceName() {
        return this.mServiceName;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.mName, this.mServiceName);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CurrentUser)) {
            return false;
        }
        CurrentUser other = (CurrentUser)o;
        return Objects.equal(this.mName, other.mName) && Objects.equal(this.mServiceName, other.mServiceName);
    }
}

