/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.WorkerNetAddress;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public class CapacityBaseRandomPolicy
implements BlockLocationPolicy {
    public CapacityBaseRandomPolicy(AlluxioConfiguration conf) {
    }

    @Override
    @Nullable
    public WorkerNetAddress getWorker(GetWorkerOptions options) {
        Iterable<BlockWorkerInfo> blockWorkerInfos = options.getBlockWorkerInfos();
        TreeMap rangeStartMap = new TreeMap();
        AtomicLong totalCapacity = new AtomicLong(0L);
        blockWorkerInfos.forEach(workerInfo -> {
            if (workerInfo.getCapacityBytes() > 0L) {
                long capacityRangeStart = totalCapacity.getAndAdd(workerInfo.getCapacityBytes());
                rangeStartMap.put(capacityRangeStart, workerInfo);
            }
        });
        if (totalCapacity.get() == 0L) {
            return null;
        }
        long randomLong = this.randomInCapacity(totalCapacity.get());
        return ((BlockWorkerInfo)rangeStartMap.floorEntry(randomLong).getValue()).getNetAddress();
    }

    protected long randomInCapacity(long totalCapacity) {
        return ThreadLocalRandom.current().nextLong(totalCapacity);
    }
}

