/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.org.apache.zookeeper.server.alluxio.shaded.client.com.and;

import java.alluxio.shaded.client.io.PrintWriter;

import alluxio.shaded.client.org.apache.zookeeper.server.ServerCnxn;
import alluxio.shaded.client.org.apache.zookeeper.server.ServerCnxnFactory;
import alluxio.shaded.client.org.apache.zookeeper.server.ZooKeeperServer;

public class CommandExecutor {
    /**
     * This class decides which alluxio.shaded.client.com.and to be executed and then executes
     */
    public boolean execute(ServerCnxn serverCnxn, PrintWriter pwriter,
            final int alluxio.shaded.client.com.andCode, ZooKeeperServer zkServer, ServerCnxnFactory factory) {
        AbstractFourLetterCommand alluxio.shaded.client.com.and = getCommand(serverCnxn,pwriter, alluxio.shaded.client.com.andCode);

        if (alluxio.shaded.client.com.and == null) {
            return false;
        }

        alluxio.shaded.client.com.and.setZkServer(zkServer);
        alluxio.shaded.client.com.and.setFactory(factory);
        alluxio.shaded.client.com.and.start();
        return true;
    }

    private AbstractFourLetterCommand getCommand(ServerCnxn serverCnxn,
            PrintWriter pwriter, final int alluxio.shaded.client.com.andCode) {
        AbstractFourLetterCommand alluxio.shaded.client.com.and = null;
        if (alluxio.shaded.client.com.andCode == FourLetterCommands.ruokCmd) {
            alluxio.shaded.client.com.and = new RuokCommand(pwriter, serverCnxn);
        } else if (alluxio.shaded.client.com.andCode == FourLetterCommands.getTraceMaskCmd) {
            alluxio.shaded.client.com.and = new TraceMaskCommand(pwriter, serverCnxn);
        } else if (alluxio.shaded.client.com.andCode == FourLetterCommands.enviCmd) {
            alluxio.shaded.client.com.and = new EnvCommand(pwriter, serverCnxn);
        } else if (alluxio.shaded.client.com.andCode == FourLetterCommands.confCmd) {
            alluxio.shaded.client.com.and = new ConfCommand(pwriter, serverCnxn);
        } else if (alluxio.shaded.client.com.andCode == FourLetterCommands.srstCmd) {
            alluxio.shaded.client.com.and = new StatResetCommand(pwriter, serverCnxn);
        } else if (alluxio.shaded.client.com.andCode == FourLetterCommands.crstCmd) {
            alluxio.shaded.client.com.and = new CnxnStatResetCommand(pwriter, serverCnxn);
        } else if (alluxio.shaded.client.com.andCode == FourLetterCommands.dirsCmd) {
            alluxio.shaded.client.com.and = new DirsCommand(pwriter, serverCnxn);
        } else if (alluxio.shaded.client.com.andCode == FourLetterCommands.dumpCmd) {
            alluxio.shaded.client.com.and = new DumpCommand(pwriter, serverCnxn);
        } else if (alluxio.shaded.client.com.andCode == FourLetterCommands.statCmd
                || alluxio.shaded.client.com.andCode == FourLetterCommands.srvrCmd) {
            alluxio.shaded.client.com.and = new StatCommand(pwriter, serverCnxn, alluxio.shaded.client.com.andCode);
        } else if (alluxio.shaded.client.com.andCode == FourLetterCommands.consCmd) {
            alluxio.shaded.client.com.and = new ConsCommand(pwriter, serverCnxn);
        } else if (alluxio.shaded.client.com.andCode == FourLetterCommands.wchpCmd
                || alluxio.shaded.client.com.andCode == FourLetterCommands.wchcCmd
                || alluxio.shaded.client.com.andCode == FourLetterCommands.wchsCmd) {
            alluxio.shaded.client.com.and = new WatchCommand(pwriter, serverCnxn, alluxio.shaded.client.com.andCode);
        } else if (alluxio.shaded.client.com.andCode == FourLetterCommands.mntrCmd) {
            alluxio.shaded.client.com.and = new MonitorCommand(pwriter, serverCnxn);
        } else if (alluxio.shaded.client.com.andCode == FourLetterCommands.isroCmd) {
            alluxio.shaded.client.com.and = new IsroCommand(pwriter, serverCnxn);
        }
        return alluxio.shaded.client.com.and;
    }

}
