/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.CacheManagerWithShadowCache;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.ShadowCacheManager;
import alluxio.client.file.cache.cuckoofilter.ClockCuckooFilter;
import alluxio.client.file.cache.cuckoofilter.ConcurrentClockCuckooFilter;
import alluxio.client.file.cache.cuckoofilter.SlidingWindowType;
import alluxio.client.quota.CacheScope;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ClockCuckooShadowCacheManager
implements ShadowCacheManager {
    private static final int BITS_PER_TAG = 8;
    private final ScheduledExecutorService mScheduler = Executors.newScheduledThreadPool(0);
    private final ClockCuckooFilter<PageId> mFilter;
    private long mShadowCacheBytes = 0L;
    private long mShadowCachePages = 0L;
    private final AtomicLong mShadowCachePageRead = new AtomicLong(0L);
    private final AtomicLong mShadowCachePageHit = new AtomicLong(0L);
    private final AtomicLong mShadowCacheByteRead = new AtomicLong(0L);
    private final AtomicLong mShadowCacheByteHit = new AtomicLong(0L);

    public ClockCuckooShadowCacheManager(AlluxioConfiguration conf) {
        long windowMs = conf.getMs(PropertyKey.USER_CLIENT_CACHE_SHADOW_WINDOW);
        long budgetInBits = conf.getBytes(PropertyKey.USER_CLIENT_CACHE_SHADOW_MEMORY_OVERHEAD) * 8L;
        int bitsPerClock = conf.getInt(PropertyKey.USER_CLIENT_CACHE_SHADOW_CUCKOO_CLOCK_BITS);
        int bitsPerSize = conf.getInt(PropertyKey.USER_CLIENT_CACHE_SHADOW_CUCKOO_SIZE_BITS);
        int bitsPerScope = conf.getInt(PropertyKey.USER_CLIENT_CACHE_SHADOW_CUCKOO_SCOPE_BITS);
        long bitsPerSlot = 8 + bitsPerClock + bitsPerSize + bitsPerScope;
        long totalSlots = budgetInBits / bitsPerSlot;
        long expectedInsertions = (long)((double)Long.highestOneBit(totalSlots) * 0.955);
        this.mFilter = ConcurrentClockCuckooFilter.create(CacheManagerWithShadowCache.PageIdFunnel.FUNNEL, expectedInsertions, bitsPerClock, bitsPerSize, bitsPerScope, SlidingWindowType.TIME_BASED, windowMs);
        long agingPeriod = windowMs >> bitsPerClock;
        this.mScheduler.scheduleAtFixedRate(this::aging, agingPeriod, agingPeriod, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean put(PageId pageId, int size, CacheScope cacheScope) {
        return this.updateClockCuckoo(pageId, size, cacheScope);
    }

    private boolean updateClockCuckoo(PageId pageId, int size, CacheScope cacheScope) {
        boolean ok = true;
        if (!this.mFilter.mightContainAndResetClock(pageId)) {
            ok = this.mFilter.put(pageId, size, cacheScope);
            this.updateWorkingSetSize();
        }
        return ok;
    }

    @Override
    public int get(PageId pageId, int bytesToRead, CacheScope cacheScope) {
        this.mShadowCachePageRead.getAndIncrement();
        this.mShadowCacheByteRead.getAndAdd(bytesToRead);
        if (this.mFilter.mightContainAndResetClock(pageId)) {
            this.mShadowCachePageHit.getAndIncrement();
            this.mShadowCacheByteHit.getAndAdd(bytesToRead);
            return bytesToRead;
        }
        return 0;
    }

    @Override
    public boolean delete(PageId pageId) {
        return this.mFilter.delete(pageId);
    }

    @Override
    public void aging() {
        this.mFilter.aging();
    }

    @Override
    public void updateWorkingSetSize() {
        this.mShadowCachePages = this.mFilter.approximateElementCount();
        this.mShadowCacheBytes = this.mFilter.approximateElementSize();
    }

    @Override
    public void stopUpdate() {
        this.mScheduler.shutdown();
    }

    @Override
    public long getShadowCachePages() {
        return this.mShadowCachePages;
    }

    @Override
    public long getShadowCachePages(CacheScope scope) {
        return this.mFilter.approximateElementCount(scope);
    }

    @Override
    public long getShadowCacheBytes() {
        return this.mShadowCacheBytes;
    }

    @Override
    public long getShadowCacheBytes(CacheScope scope) {
        return this.mFilter.approximateElementSize(scope);
    }

    @Override
    public long getShadowCachePageRead() {
        return this.mShadowCachePageRead.get();
    }

    @Override
    public long getShadowCachePageHit() {
        return this.mShadowCachePageHit.get();
    }

    @Override
    public long getShadowCacheByteRead() {
        return this.mShadowCacheByteRead.get();
    }

    @Override
    public long getShadowCacheByteHit() {
        return this.mShadowCacheByteHit.get();
    }

    @Override
    public double getFalsePositiveRatio() {
        return this.mFilter.expectedFpp();
    }
}

