/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.block.stream.DataReader;
import alluxio.client.file.options.InStreamOptions;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.NioDataBuffer;
import alluxio.proto.dataserver.Protocol;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.IdUtils;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.block.io.BlockReader;
import java.io.IOException;
import java.nio.ByteBuffer;

@NotThreadSafe
public final class BlockWorkerDataReader
implements DataReader {
    private final BlockReader mReader;
    private final long mEnd;
    private final long mChunkSize;
    private long mPos;
    private boolean mClosed;

    private BlockWorkerDataReader(BlockReader reader, long offset, long len, long chunkSize) {
        this.mReader = reader;
        Preconditions.checkArgument(chunkSize > 0L);
        this.mPos = offset;
        this.mEnd = Math.min(this.mReader.getLength(), offset + len);
        this.mChunkSize = chunkSize;
    }

    @Override
    public DataBuffer readChunk() throws IOException {
        if (this.mPos >= this.mEnd) {
            return null;
        }
        ByteBuffer buffer = this.mReader.read(this.mPos, Math.min(this.mChunkSize, this.mEnd - this.mPos));
        NioDataBuffer dataBuffer = new NioDataBuffer(buffer, buffer.remaining());
        this.mPos += dataBuffer.getLength();
        MetricsSystem.counter(MetricKey.WORKER_BYTES_READ_DIRECT.getName()).inc(dataBuffer.getLength());
        MetricsSystem.meter(MetricKey.WORKER_BYTES_READ_DIRECT_THROUGHPUT.getName()).mark(dataBuffer.getLength());
        return dataBuffer;
    }

    @Override
    public long pos() {
        return this.mPos;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        if (this.mReader != null) {
            this.mReader.close();
        }
        this.mClosed = true;
    }

    @NotThreadSafe
    public static class Factory
    implements DataReader.Factory {
        private final long mChunkSize;
        private final BlockWorker mBlockWorker;
        private final long mBlockId;
        private final boolean mIsPositionShort;
        private final Protocol.OpenUfsBlockOptions mOpenUfsBlockOptions;

        public Factory(BlockWorker blockWorker, long blockId, long chunkSize, InStreamOptions options) {
            Preconditions.checkNotNull(blockWorker);
            this.mBlockId = blockId;
            this.mBlockWorker = blockWorker;
            this.mChunkSize = chunkSize;
            this.mIsPositionShort = options.getPositionShort();
            this.mOpenUfsBlockOptions = options.getOpenUfsBlockOptions(blockId);
        }

        @Override
        public DataReader create(long offset, long len) throws IOException {
            try {
                BlockReader reader = this.mBlockWorker.createBlockReader(IdUtils.createSessionId(), this.mBlockId, offset, this.mIsPositionShort, this.mOpenUfsBlockOptions);
                return new BlockWorkerDataReader(reader, offset, len, this.mChunkSize);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public void close() throws IOException {
        }
    }
}

